/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.validation;

import java.util.Collection;
import java.util.Collections;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.shacl.Shapes;
import org.apache.jena.shacl.ValidationReport;
import org.apache.jena.shacl.engine.ValidationContext;
import org.apache.jena.shacl.parser.Shape;
import org.apache.jena.shacl.validation.VLib;
import org.apache.jena.shacl.validation.event.FocusNodesDeterminedEvent;
import org.apache.jena.shacl.validation.event.ShapeValidationFinishedEvent;
import org.apache.jena.shacl.validation.event.ShapeValidationStartedEvent;
import org.apache.jena.shacl.validation.event.TargetShapesValidationFinishedEvent;
import org.apache.jena.shacl.validation.event.TargetShapesValidationStartedEvent;

public class ValidationProc {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ValidationReport plainValidation(Shapes shapes, Graph data) {
        ValidationContext vCxt = ValidationContext.create(shapes, data);
        int x = vCxt.out().getAbsoluteIndent();
        try {
            ValidationReport validationReport = ValidationProc.plainValidation(vCxt, shapes, data);
            return validationReport;
        }
        finally {
            vCxt.out().setAbsoluteIndent(x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ValidationReport plainValidation(ValidationContext vCxt, Shapes shapes, Graph data) {
        Collection<Shape> targetShapes = shapes.getTargetShapes();
        vCxt.notifyValidationListener(() -> new TargetShapesValidationStartedEvent(vCxt, targetShapes));
        try {
            targetShapes.forEach(shape -> ValidationProc.plainValidation(vCxt, shape, data));
            if (vCxt.isVerbose()) {
                vCxt.out().ensureStartOfLine();
            }
            ValidationReport validationReport = vCxt.generateReport();
            return validationReport;
        }
        finally {
            vCxt.notifyValidationListener(() -> new TargetShapesValidationFinishedEvent(vCxt, targetShapes));
        }
    }

    private static void plainValidation(ValidationContext vCxt, Shape shape, Graph data) {
        ValidationProc.plainValidationInternal(vCxt, data, null, shape);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ValidationReport plainValidationNode(Shapes shapes, Graph data, Node node) {
        ValidationContext vCxt = ValidationContext.create(shapes, data);
        int x = vCxt.out().getAbsoluteIndent();
        try {
            ValidationReport validationReport = ValidationProc.plainValidationNode(vCxt, shapes, node, data);
            return validationReport;
        }
        finally {
            vCxt.out().setAbsoluteIndent(x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ValidationReport plainValidationNode(ValidationContext vCxt, Shapes shapes, Node node, Graph data) {
        Collection<Shape> targetShapes = shapes.getTargetShapes();
        vCxt.notifyValidationListener(() -> new TargetShapesValidationStartedEvent(vCxt, targetShapes));
        try {
            targetShapes.forEach(shape -> ValidationProc.plainValidationNode(vCxt, data, node, shape));
            if (vCxt.isVerbose()) {
                vCxt.out().ensureStartOfLine();
            }
            ValidationReport validationReport = vCxt.generateReport();
            return validationReport;
        }
        finally {
            vCxt.notifyValidationListener(() -> new TargetShapesValidationFinishedEvent(vCxt, targetShapes));
        }
    }

    private static void plainValidationNode(ValidationContext vCxt, Graph data, Node node, Shape shape) {
        ValidationProc.plainValidationInternal(vCxt, data, node, shape);
    }

    private static void plainValidationInternal(ValidationContext vCxt, Graph data, Node node, Shape shape) {
        Collection<Node> focusNodes;
        vCxt.notifyValidationListener(() -> new ShapeValidationStartedEvent(vCxt, shape));
        if (node != null) {
            if (!VLib.isFocusNode(shape, node, data)) {
                return;
            }
            focusNodes = Collections.singleton(node);
        } else {
            focusNodes = VLib.focusNodes(data, shape);
        }
        vCxt.notifyValidationListener(() -> new FocusNodesDeterminedEvent(vCxt, shape, focusNodes));
        if (vCxt.isVerbose()) {
            vCxt.out().println(shape.toString());
            vCxt.out().printf("N: FocusNodes(%d): %s\n", new Object[]{focusNodes.size(), focusNodes});
        }
        vCxt.out().incIndent();
        for (Node focusNode : focusNodes) {
            if (vCxt.isVerbose()) {
                vCxt.out().println("F: " + focusNode);
            }
            VLib.validateShape(vCxt, data, shape, focusNode);
        }
        vCxt.out().decIndent();
        vCxt.notifyValidationListener(() -> new ShapeValidationFinishedEvent(vCxt, shape));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execValidateShape(ValidationContext vCxt, Graph data, Shape shape, Node focusNode) {
        vCxt.notifyValidationListener(() -> new ShapeValidationStartedEvent(vCxt, shape));
        try {
            VLib.validateShape(vCxt, data, shape, focusNode);
        }
        finally {
            vCxt.notifyValidationListener(() -> new ShapeValidationFinishedEvent(vCxt, shape));
        }
    }
}

