/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.AWriterBase;
import org.apache.jena.atlas.io.BufferingWriter;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.Closeable;

public class Writer2
extends AWriterBase
implements AWriter,
Closeable {
    protected final Writer writer;

    public static Writer2 wrapNoBuffer(Writer writer) {
        return new Writer2(writer);
    }

    public static Writer2 wrap(Writer writer) {
        if (writer instanceof BufferedWriter) {
            return new Writer2(writer);
        }
        if (writer instanceof BufferingWriter) {
            return new Writer2(writer);
        }
        writer = new BufferingWriter(writer);
        return new Writer2(writer);
    }

    protected Writer2(Writer writer) {
        this.writer = writer;
    }

    @Override
    public AWriter print(char ch) {
        try {
            this.writer.write(ch);
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
        return this;
    }

    @Override
    public AWriter print(String string) {
        try {
            this.writer.write(string);
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
        return this;
    }

    @Override
    public AWriter print(char[] cbuf) {
        try {
            this.writer.write(cbuf);
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
        return this;
    }

    @Override
    public AWriter flush() {
        try {
            this.writer.flush();
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
        return this;
    }

    @Override
    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    @Override
    public AWriter printf(String fmt, Object ... args) {
        this.print(String.format(fmt, args));
        return this;
    }

    @Override
    public AWriter println(String obj) {
        this.print(obj);
        this.print("\n");
        return this;
    }

    @Override
    public AWriter println() {
        this.print("\n");
        return this;
    }

    public String toString() {
        return this.writer.toString();
    }
}

