/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2;

import org.apache.jena.dboe.base.file.Location;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.tdb2.TDBException;
import org.apache.jena.tdb2.store.DatasetGraphSwitchable;
import org.apache.jena.tdb2.store.DatasetGraphTDB;
import org.apache.jena.tdb2.sys.DatabaseConnection;
import org.apache.jena.tdb2.sys.DatabaseOps;
import org.apache.jena.tdb2.sys.TDBInternal;

public class DatabaseMgr {
    private DatabaseMgr() {
    }

    private static DatasetGraph DB_ConnectCreate(Location location) {
        return DatabaseConnection.connectCreate(location).getDatasetGraph();
    }

    public static DatasetGraph connectDatasetGraph(Location location) {
        return DatabaseMgr.DB_ConnectCreate(location);
    }

    public static DatasetGraph connectDatasetGraph(String location) {
        return DatabaseMgr.connectDatasetGraph(Location.create((String)location));
    }

    public static void compact(DatasetGraph container) {
        DatabaseMgr.compact(container, false);
    }

    public static void compact(DatasetGraph container, boolean shouldDeleteOld) {
        DatasetGraphSwitchable dsg = DatabaseMgr.requireSwitchable(container);
        DatabaseOps.compact(dsg, shouldDeleteOld);
    }

    public static String backup(DatasetGraph container) {
        DatasetGraphSwitchable dsg = DatabaseMgr.requireSwitchable(container);
        return DatabaseOps.backup(dsg);
    }

    public static DatasetGraph createDatasetGraph() {
        return DatabaseMgr.connectDatasetGraph(Location.mem());
    }

    public static boolean isTDB2(DatasetGraph datasetGraph) {
        return TDBInternal.isTDB2(datasetGraph);
    }

    public static Location location(DatasetGraph datasetGraph) {
        DatasetGraphSwitchable dsg = DatabaseMgr.requireSwitchable(datasetGraph);
        if (dsg == null) {
            return null;
        }
        return dsg.getLocation();
    }

    private static DatasetGraphSwitchable requireSwitchable(DatasetGraph datasetGraph) {
        if (datasetGraph instanceof DatasetGraphSwitchable) {
            DatasetGraphSwitchable dsgx = (DatasetGraphSwitchable)datasetGraph;
            return dsgx;
        }
        throw new TDBException("Not a switchable TDB database");
    }

    static DatasetGraphTDB requireDirect(DatasetGraph datasetGraph) {
        DatasetGraphTDB dsg = TDBInternal.getDatasetGraphTDB(datasetGraph);
        if (dsg == null) {
            throw new TDBException("Not a TDB database (argument is neither a switchable nor direct TDB DatasetGraph)");
        }
        return dsg;
    }
}

