/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.service.ServiceExec;
import org.apache.jena.sparql.service.bulk.ChainingServiceExecutorBulk;
import org.apache.jena.sparql.service.single.ChainingServiceExecutor;
import org.apache.jena.sparql.service.single.ChainingServiceExecutorWrapper;
import org.apache.jena.sparql.service.single.ServiceExecutor;
import org.apache.jena.sparql.service.single.ServiceExecutorHttp;
import org.apache.jena.sparql.util.Context;

public class ServiceExecutorRegistry {
    List<ChainingServiceExecutorBulk> bulkChain = new ArrayList<ChainingServiceExecutorBulk>();
    List<ChainingServiceExecutor> singleChain = new ArrayList<ChainingServiceExecutor>();
    public static ServiceExecutor httpService = new ServiceExecutorHttp();

    public static ServiceExecutorRegistry standardRegistry() {
        ServiceExecutorRegistry reg = ServiceExecutorRegistry.get(ARQ.getContext());
        return reg;
    }

    public static void initWithDefaults(ServiceExecutorRegistry registry) {
        registry.add(httpService);
    }

    public static void init() {
        ServiceExecutorRegistry reg = new ServiceExecutorRegistry();
        ServiceExecutorRegistry.initWithDefaults(reg);
        ServiceExecutorRegistry.set(ARQ.getContext(), reg);
    }

    public static ServiceExecutorRegistry get() {
        ServiceExecutorRegistry reg = ServiceExecutorRegistry.get(ARQ.getContext());
        if (reg == null) {
            ServiceExecutorRegistry.init();
            reg = ServiceExecutorRegistry.get(ARQ.getContext());
        }
        return reg;
    }

    public static ServiceExecutorRegistry chooseRegistry(Context context2) {
        ServiceExecutorRegistry result = ServiceExecutorRegistry.get(context2);
        if (result == null) {
            result = ServiceExecutorRegistry.get();
        }
        return result;
    }

    public static ServiceExecutorRegistry get(Context context2) {
        if (context2 == null) {
            return null;
        }
        return (ServiceExecutorRegistry)context2.get(ARQConstants.registryServiceExecutors);
    }

    public static void set(Context context2, ServiceExecutorRegistry reg) {
        context2.set(ARQConstants.registryServiceExecutors, reg);
    }

    public static ServiceExecutorRegistry createFrom(ServiceExecutorRegistry from) {
        ServiceExecutorRegistry res = new ServiceExecutorRegistry();
        if (from != null) {
            res.bulkChain.addAll(from.bulkChain);
            res.singleChain.addAll(from.singleChain);
        }
        return res;
    }

    public ServiceExecutorRegistry addSingleLink(ChainingServiceExecutor f) {
        Objects.requireNonNull(f);
        this.singleChain.add(0, f);
        return this;
    }

    public ServiceExecutorRegistry removeSingleLink(ChainingServiceExecutor f) {
        this.singleChain.remove(f);
        return this;
    }

    public ServiceExecutorRegistry add(ServiceExecutor f) {
        Objects.requireNonNull(f);
        return this.addSingleLink(new ChainingServiceExecutorWrapper(f));
    }

    public ServiceExecutorRegistry remove(ServiceExecutor f) {
        Iterator<ChainingServiceExecutor> it = this.singleChain.iterator();
        while (it.hasNext()) {
            ChainingServiceExecutorWrapper wrapper;
            ServiceExecutor delegate;
            ChainingServiceExecutor cse = it.next();
            if (!(cse instanceof ChainingServiceExecutorWrapper) || !Objects.equals(delegate = (wrapper = (ChainingServiceExecutorWrapper)cse).getDelegate(), f)) continue;
            it.remove();
        }
        return this;
    }

    public List<ChainingServiceExecutor> getSingleChain() {
        return this.singleChain;
    }

    public ServiceExecutorRegistry addBulkLink(ChainingServiceExecutorBulk f) {
        Objects.requireNonNull(f);
        this.bulkChain.add(0, f);
        return this;
    }

    public ServiceExecutorRegistry removeBulkLink(ChainingServiceExecutorBulk f) {
        this.bulkChain.remove(f);
        return this;
    }

    public List<ChainingServiceExecutorBulk> getBulkChain() {
        return this.bulkChain;
    }

    public ServiceExecutorRegistry copy() {
        ServiceExecutorRegistry result = new ServiceExecutorRegistry();
        result.getSingleChain().addAll(this.getSingleChain());
        result.getBulkChain().addAll(this.getBulkChain());
        return result;
    }

    public ServiceExecutorRegistry copyFrom(Context cxt) {
        ServiceExecutorRegistry tmp = ServiceExecutorRegistry.get(cxt);
        ServiceExecutorRegistry result = tmp == null ? new ServiceExecutorRegistry() : tmp.copy();
        return result;
    }

    @Deprecated(since="4.9.0")
    public static QueryIterator exec(QueryIterator input, OpService opService, ExecutionContext execCxt) {
        return ServiceExec.exec(input, opService, execCxt);
    }
}

