/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.mem;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.apache.jena.mem.SparseArraySpliterator;
import org.apache.jena.shared.BrokenException;
import org.apache.jena.shared.JenaException;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NiceIterator;

public abstract class HashCommon<Key> {
    protected static final double loadFactor = 0.5;
    protected Key[] keys;
    public int capacity;
    protected int threshold;
    protected int size = 0;
    protected int changes;
    static final int[] primes = new int[]{7, 19, 37, 79, 149, 307, 617, 1237, 2477, 4957, 9923, 19853, 39709, 79423, 158849, 317701, 635413, 1270849, 2541701, 5083423, 10166857, 20333759, 40667527, 81335047, 162670111, 325340233, 650680469, 982451653};

    protected HashCommon(int initialCapacity) {
        this.capacity = initialCapacity;
        this.keys = this.newKeyArray(this.capacity);
        this.threshold = (int)((double)this.capacity * 0.5);
    }

    protected abstract Key[] newKeyArray(int var1);

    protected void removeAssociatedValues(int here) {
    }

    protected void moveAssociatedValues(int here, int scan) {
    }

    public Object getItemForTestingAt(int i) {
        return this.keys[i];
    }

    protected final int initialIndexFor(Object key) {
        return (this.improveHashCode(key.hashCode()) & Integer.MAX_VALUE) % this.capacity;
    }

    protected int improveHashCode(int hashCode) {
        return hashCode * 127;
    }

    protected final int findSlot(Key key) {
        int index = this.initialIndexFor(key);
        Key current;
        while ((current = this.keys[index]) != null) {
            if (key.equals(current)) {
                return ~index;
            }
            if (--index >= 0) continue;
            index += this.capacity;
        }
        return index;
    }

    public void remove(Key key) {
        this.primitiveRemove(key);
    }

    protected void primitiveRemove(Key key) {
        int slot = this.findSlot(key);
        if (slot < 0) {
            this.removeFrom(~slot);
        }
    }

    protected void growCapacityAndThreshold() {
        this.capacity = HashCommon.nextSize(this.capacity * 2);
        this.threshold = (int)((double)this.capacity * 0.5);
    }

    protected static int nextSize(int atLeast) {
        for (int prime : primes) {
            if (prime <= atLeast) continue;
            return prime;
        }
        throw new JenaException("Failed to find a 'next size': atleast = " + atLeast);
    }

    protected Key removeFrom(int here) {
        int original = here;
        Key wrappedAround = null;
        --this.size;
        while (true) {
            Key key;
            int r;
            this.keys[here] = null;
            this.removeAssociatedValues(here);
            int scan = here;
            do {
                if (--scan < 0) {
                    scan += this.capacity;
                }
                if ((key = this.keys[scan]) != null) continue;
                return wrappedAround;
            } while (scan <= (r = this.initialIndexFor(key)) && r < here || r < here && here < scan || here < scan && scan <= r);
            if (here >= original && scan < original) {
                wrappedAround = this.keys[scan];
            }
            this.keys[here] = this.keys[scan];
            this.moveAssociatedValues(here, scan);
            here = scan;
        }
    }

    void showkeys() {
    }

    public ExtendedIterator<Key> keyIterator() {
        return this.keyIterator(NotifyEmpty.ignore);
    }

    public ExtendedIterator<Key> keyIterator(NotifyEmpty container) {
        this.showkeys();
        ArrayList movedKeys = new ArrayList();
        BasicKeyIterator basic = new BasicKeyIterator(this.changes, container, movedKeys);
        MovedKeysIterator leftovers = new MovedKeysIterator(this.changes, container, movedKeys);
        return basic.andThen(leftovers);
    }

    public Spliterator<Key> keySpliterator() {
        int initialChanges = this.changes;
        Runnable checkForConcurrentModification = () -> {
            if (this.changes != initialChanges) {
                throw new ConcurrentModificationException();
            }
        };
        return new SparseArraySpliterator<Key>(this.keys, this.size, checkForConcurrentModification);
    }

    public static interface NotifyEmpty {
        public static final NotifyEmpty ignore = new NotifyEmpty(){

            @Override
            public void emptied() {
            }
        };

        public void emptied();
    }

    protected final class BasicKeyIterator
    extends NiceIterator<Key> {
        protected final List<Key> movedKeys;
        int pos;
        final int initialChanges;
        final NotifyEmpty container;

        protected BasicKeyIterator(int initialChanges, NotifyEmpty container, List<Key> movedKeys) {
            this.pos = HashCommon.this.capacity - 1;
            this.movedKeys = movedKeys;
            this.initialChanges = initialChanges;
            this.container = container;
        }

        @Override
        public boolean hasNext() {
            while (-1 < this.pos) {
                if (null != HashCommon.this.keys[this.pos]) {
                    return true;
                }
                --this.pos;
            }
            return false;
        }

        @Override
        public Key next() {
            if (HashCommon.this.changes > this.initialChanges) {
                throw new ConcurrentModificationException();
            }
            if (-1 < this.pos && null != HashCommon.this.keys[this.pos]) {
                return HashCommon.this.keys[this.pos--];
            }
            throw new NoSuchElementException("HashCommon keys");
        }

        public void forEachRemaining(Consumer<? super Key> action) {
            while (-1 < this.pos) {
                if (null != HashCommon.this.keys[this.pos]) {
                    action.accept(HashCommon.this.keys[this.pos]);
                }
                --this.pos;
            }
            if (HashCommon.this.changes > this.initialChanges) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void remove() {
            if (HashCommon.this.changes > this.initialChanges) {
                throw new ConcurrentModificationException();
            }
            Object moved = HashCommon.this.removeFrom(this.pos + 1);
            if (moved != null) {
                this.movedKeys.add(moved);
            }
            if (HashCommon.this.size == 0) {
                this.container.emptied();
            }
            if (HashCommon.this.size < 0) {
                throw new BrokenException("BROKEN");
            }
            HashCommon.this.showkeys();
        }
    }

    protected final class MovedKeysIterator
    extends NiceIterator<Key> {
        private final List<Key> movedKeys;
        protected int index = 0;
        final int initialChanges;
        final NotifyEmpty container;

        protected MovedKeysIterator(int initialChanges, NotifyEmpty container, List<Key> keys) {
            this.movedKeys = keys;
            this.initialChanges = initialChanges;
            this.container = container;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.movedKeys.size();
        }

        @Override
        public Key next() {
            if (HashCommon.this.changes > this.initialChanges) {
                throw new ConcurrentModificationException("changes " + HashCommon.this.changes + " > initialChanges " + this.initialChanges);
            }
            if (this.index < this.movedKeys.size()) {
                return this.movedKeys.get(this.index++);
            }
            return this.noElements("");
        }

        public void forEachRemaining(Consumer<? super Key> action) {
            while (this.index < this.movedKeys.size()) {
                action.accept(this.movedKeys.get(this.index++));
            }
            if (HashCommon.this.changes > this.initialChanges) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void remove() {
            if (HashCommon.this.changes > this.initialChanges) {
                throw new ConcurrentModificationException();
            }
            HashCommon.this.primitiveRemove(this.movedKeys.get(this.index - 1));
            if (HashCommon.this.size == 0) {
                this.container.emptied();
            }
        }
    }
}

