/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.rulesys;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.List;
import org.apache.jena.datatypes.xsd.XSDDateTime;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.LiteralLabelFactory;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.reasoner.Finder;
import org.apache.jena.reasoner.IllegalParameterException;
import org.apache.jena.reasoner.TriplePattern;
import org.apache.jena.reasoner.rulesys.Rule;
import org.apache.jena.reasoner.rulesys.RuleContext;
import org.apache.jena.util.FileUtils;
import org.apache.jena.util.iterator.ClosableIterator;
import org.apache.jena.vocabulary.RDF;

public class Util {
    public static boolean isNumeric(Node n) {
        return n.isLiteral() && n.getLiteralValue() instanceof Number;
    }

    public static int getIntValue(Node n) {
        return ((Number)n.getLiteralValue()).intValue();
    }

    public static boolean isInstant(Node n) {
        if (n.isLiteral()) {
            Object o = n.getLiteralValue();
            return o instanceof XSDDateTime;
        }
        return false;
    }

    public static boolean comparable(Node n1, Node n2) {
        return Util.isNumeric(n1) && Util.isNumeric(n2) || Util.isInstant(n1) && Util.isInstant(n2);
    }

    public static int compareNumbers(Node n1, Node n2) {
        if (n1.isLiteral() && n2.isLiteral()) {
            Object v1 = n1.getLiteralValue();
            Object v2 = n2.getLiteralValue();
            if (v1 instanceof Number && v2 instanceof Number) {
                Number num1 = (Number)v1;
                Number num2 = (Number)v2;
                return Util.compareNumbers(num1, num2);
            }
        }
        throw new ClassCastException("Non-numeric literal in compareNumbers");
    }

    static int compareNumbers(Number num1, Number num2) {
        if (Util.valueIsLong(num1) && Util.valueIsLong(num2)) {
            long z1 = num1.longValue();
            long z2 = num2.longValue();
            return Long.compare(z1, z2);
        }
        if (Util.valueIsDouble(num1) && Util.valueIsDouble(num2)) {
            double d1 = num1.doubleValue();
            double d2 = num2.doubleValue();
            return Double.compare(d1, d2);
        }
        if (num1 instanceof BigDecimal && num2 instanceof BigDecimal) {
            BigDecimal dec1 = (BigDecimal)num1;
            BigDecimal dec2 = (BigDecimal)num2;
            return dec1.compareTo(dec2);
        }
        if (num1 instanceof BigInteger && num2 instanceof BigInteger) {
            BigInteger int1 = (BigInteger)num1;
            BigInteger int2 = (BigInteger)num2;
            return int1.compareTo(int2);
        }
        BigDecimal dec1 = Util.convertToBigDecimal(num1);
        BigDecimal dec2 = Util.convertToBigDecimal(num2);
        return dec1.compareTo(dec2);
    }

    private static BigDecimal convertToBigDecimal(Number num) {
        if (num instanceof BigDecimal) {
            return (BigDecimal)num;
        }
        if (Util.valueIsLong(num)) {
            return new BigDecimal(num.longValue());
        }
        if (num instanceof BigInteger) {
            return new BigDecimal((BigInteger)num);
        }
        return new BigDecimal(num.doubleValue());
    }

    private static boolean valueIsLong(Number v) {
        if (v instanceof Long) {
            return true;
        }
        if (v instanceof Integer) {
            return true;
        }
        if (v instanceof Short) {
            return true;
        }
        return v instanceof Byte;
    }

    private static boolean valueIsDouble(Number v) {
        if (v instanceof Double) {
            return true;
        }
        return v instanceof Float;
    }

    public static int compareInstants(Node n1, Node n2) {
        if (n1.isLiteral() && n2.isLiteral()) {
            Object v1 = n1.getLiteralValue();
            Object v2 = n2.getLiteralValue();
            if (v1 instanceof XSDDateTime && v2 instanceof XSDDateTime) {
                XSDDateTime a = (XSDDateTime)v1;
                XSDDateTime b = (XSDDateTime)v2;
                return a.compare(b);
            }
        }
        throw new ClassCastException("Non-numeric literal in compareNumbers");
    }

    public static int compareTypedLiterals(Node n1, Node n2) {
        if (n1.isLiteral() && n2.isLiteral()) {
            Object v1 = n1.getLiteralValue();
            Object v2 = n2.getLiteralValue();
            if (v1 instanceof Number && v2 instanceof Number) {
                return Util.compareNumbers((Number)v1, (Number)v2);
            }
            if (v1 instanceof XSDDateTime && v2 instanceof XSDDateTime) {
                XSDDateTime a = (XSDDateTime)v1;
                XSDDateTime b = (XSDDateTime)v2;
                return a.compare(b);
            }
        }
        throw new ClassCastException("Compare typed literals can only compare numbers and datetimes");
    }

    public static Node getPropValue(Node root, Node prop, Finder context) {
        return Util.doGetPropValue(context.find(new TriplePattern(root, prop, null)));
    }

    public static Node getPropValue(Node root, Node prop, Graph context) {
        return Util.doGetPropValue(context.find(root, prop, null));
    }

    public static Node getPropValue(Node root, Node prop, RuleContext context) {
        return Util.doGetPropValue(context.find(root, prop, null));
    }

    private static Node doGetPropValue(ClosableIterator<Triple> it) {
        Node result = null;
        if (it.hasNext()) {
            result = ((Triple)it.next()).getObject();
        }
        it.close();
        return result;
    }

    public static List<Node> convertList(Node root, RuleContext context) {
        return Util.convertList(root, context, new LinkedList<Node>());
    }

    private static List<Node> convertList(Node node, RuleContext context, List<Node> sofar) {
        if (node == null || node.equals(RDF.nil.asNode())) {
            return sofar;
        }
        Node next = Util.getPropValue(node, RDF.first.asNode(), context);
        if (next != null) {
            sofar.add(next);
            return Util.convertList(Util.getPropValue(node, RDF.rest.asNode(), context), context, sofar);
        }
        return sofar;
    }

    public static Node makeIntNode(int value) {
        return NodeFactory.createLiteral(LiteralLabelFactory.createTypedLiteral(value));
    }

    public static Node makeLongNode(long value) {
        if (value > Integer.MAX_VALUE) {
            return NodeFactory.createLiteral(LiteralLabelFactory.createTypedLiteral(value));
        }
        return NodeFactory.createLiteral(LiteralLabelFactory.createTypedLiteral((int)value));
    }

    public static Node makeDoubleNode(double value) {
        return NodeFactory.createLiteral(LiteralLabelFactory.createTypedLiteral(value));
    }

    public static Node makeList(Node[] nodes, Graph graph) {
        return Util.doMakeList(nodes, 0, graph);
    }

    private static Node doMakeList(Node[] nodes, int next, Graph graph) {
        if (next < nodes.length) {
            Node listNode = NodeFactory.createBlankNode();
            graph.add(Triple.create(listNode, RDF.Nodes.first, nodes[next]));
            graph.add(Triple.create(listNode, RDF.Nodes.rest, Util.doMakeList(nodes, next + 1, graph)));
            return listNode;
        }
        return RDF.Nodes.nil;
    }

    public static Rule.Parser loadRuleParserFromResourceFile(String filename) {
        return Rule.rulesParserFromReader(FileUtils.openResourceFile(filename));
    }

    public static String loadURLFile(String urlStr) throws IOException {
        try (BufferedReader dataReader = FileUtils.readerFromURL(urlStr);){
            String string;
            try (StringWriter sw = new StringWriter(1024);){
                int l;
                char[] buff = new char[1024];
                while (dataReader.ready() && (l = dataReader.read(buff)) > 0) {
                    sw.write(buff, 0, l);
                }
                string = sw.toString();
            }
            return string;
        }
    }

    public static Boolean checkBinaryPredicate(Property predicate, Resource configuration) {
        StmtIterator i = configuration.listProperties(predicate);
        if (i.hasNext()) {
            return i.nextStatement().getObject().toString().equalsIgnoreCase("true");
        }
        return null;
    }

    public static Integer getIntegerPredicate(Property predicate, Resource configuration) {
        RDFNode lit;
        StmtIterator i = configuration.listProperties(predicate);
        if (i.hasNext() && (lit = i.nextStatement().getObject()) instanceof Literal) {
            return ((Literal)lit).getInt();
        }
        return null;
    }

    public static boolean convertBooleanPredicateArg(Property parameter, Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return ((String)value).equalsIgnoreCase("true");
        }
        throw new IllegalParameterException("Illegal type for " + parameter + " setting - use a Boolean");
    }

    public static int convertIntegerPredicateArg(Property parameter, Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                throw new IllegalParameterException("Illegal type for " + parameter + " setting - use an integer");
            }
        }
        throw new IllegalParameterException("Illegal type for " + parameter + " setting - use an integer");
    }

    public static void updateParameter(Resource config, Property parameter, Object value) {
        StmtIterator i = config.listProperties(parameter);
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
        config.addProperty(parameter, value.toString());
    }
}

