/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core.assembler;

import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.assembler.exceptions.AssemblerException;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.assembler.DatasetAssemblerVocab;
import org.apache.jena.sparql.util.graph.GraphUtils;

public abstract class DatasetAssembler
extends AssemblerBase
implements Assembler {
    public static Resource getType() {
        return DatasetAssemblerVocab.tDataset;
    }

    public Dataset open(Assembler a, Resource root2, Mode mode) {
        DatasetGraph dsg = this.createDataset(a, root2);
        return DatasetFactory.wrap(dsg);
    }

    public abstract DatasetGraph createDataset(Assembler var1, Resource var2);

    protected DatasetGraph createBaseDataset(Resource dbAssem, Property pDataset) {
        Resource dataset = GraphUtils.getResourceValue(dbAssem, pDataset);
        if (dataset == null) {
            throw new AssemblerException(dbAssem, "Required base dataset missing: " + dbAssem);
        }
        Dataset base = (Dataset)Assembler.general.open(dataset);
        return base.asDatasetGraph();
    }
}

