/*
 * Decompiled with CFR 0.152.
 */
package arq;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.rdf.model.AnonId;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.sparql.util.Closure;

public class rdfdiff {
    public static void main(String ... args) {
        if (args.length < 2 || args.length > 6) {
            rdfdiff.usage();
            System.exit(-1);
        }
        String in1 = args[0];
        String in2 = args[1];
        String lang1 = "RDF/XML";
        if (args.length >= 3) {
            lang1 = args[2];
        }
        String lang2 = "N-TRIPLE";
        if (args.length >= 4) {
            lang2 = args[3];
        }
        String base1 = null;
        if (args.length >= 5) {
            base1 = args[4];
        }
        String base2 = base1;
        if (args.length >= 6) {
            base2 = args[5];
        }
        try {
            Model m1 = ModelFactory.createDefaultModel();
            Model m2 = ModelFactory.createDefaultModel();
            rdfdiff.read(m1, in1, lang1, base1);
            rdfdiff.read(m2, in2, lang2, base2);
            if (m1.isIsomorphicWith(m2)) {
                System.out.println("models are equal");
                System.out.println();
                System.exit(0);
            } else {
                System.out.println("models are unequal");
                System.out.println();
                if (m1.size() != m2.size()) {
                    System.out.println(String.format("< %,d triples", m1.size()));
                    System.out.println(String.format("> %,d triples", m2.size()));
                }
                HashMap<AnonId, Model> m1SubGraphs = new HashMap<AnonId, Model>();
                StmtIterator iter = m1.listStatements();
                while (iter.hasNext()) {
                    Statement stmt = (Statement)iter.next();
                    if (stmt.asTriple().isConcrete()) {
                        if (m2.contains(stmt)) continue;
                        System.out.print("< ");
                        System.out.println(stmt.toString());
                        continue;
                    }
                    rdfdiff.addToSubGraph(stmt, m1SubGraphs);
                }
                HashMap<AnonId, Model> m2SubGraphs = new HashMap<AnonId, Model>();
                iter = m2.listStatements();
                while (iter.hasNext()) {
                    Statement stmt = (Statement)iter.next();
                    if (stmt.asTriple().isConcrete()) {
                        if (m1.contains(stmt)) continue;
                        System.out.print("> ");
                        System.out.println(stmt.toString());
                        continue;
                    }
                    rdfdiff.addToSubGraph(stmt, m2SubGraphs);
                }
                TreeSet<Model> m1SubGraphSet = new TreeSet<Model>(new ModelReferenceComparator());
                m1SubGraphSet.addAll(m1SubGraphs.values());
                TreeSet<Model> m2SubGraphSet = new TreeSet<Model>(new ModelReferenceComparator());
                m2SubGraphSet.addAll(m2SubGraphs.values());
                if (m1SubGraphSet.size() != m2SubGraphSet.size()) {
                    System.out.println("< " + m1SubGraphs.size() + " sub-graphs");
                    System.out.println("> " + m2SubGraphs.size() + " sub-graphs");
                }
                if (m1SubGraphSet.size() > 0) {
                    rdfdiff.diffSubGraphs(m1SubGraphSet, m2SubGraphSet, "< ");
                }
                if (m2SubGraphSet.size() > 0) {
                    rdfdiff.diffSubGraphs(m2SubGraphSet, m1SubGraphSet, "> ");
                }
                System.exit(1);
            }
        }
        catch (Exception e) {
            System.err.println("Unhandled exception:");
            System.err.println("    " + e.toString());
            System.exit(-1);
        }
    }

    private static void diffSubGraphs(Set<Model> m1SubGraphSet, Set<Model> m2SubGraphSet, String prefix) {
        for (Model subGraph : m1SubGraphSet) {
            ArrayList<Model> candidates = new ArrayList<Model>();
            for (Model subGraphCandidate : m2SubGraphSet) {
                if (subGraph.size() != subGraphCandidate.size()) continue;
                candidates.add(subGraph);
            }
            if (candidates.size() == 0) {
                rdfdiff.printNonMatchingSubGraph(prefix, subGraph);
                continue;
            }
            if (candidates.size() == 1) {
                if (!subGraph.isIsomorphicWith((Model)candidates.get(0))) {
                    rdfdiff.printNonMatchingSubGraph(prefix, subGraph);
                    continue;
                }
                m2SubGraphSet.remove(candidates.get(0));
                continue;
            }
            boolean matched = false;
            for (Model subGraphCandidate : candidates) {
                if (!subGraph.isIsomorphicWith(subGraphCandidate)) continue;
                matched = true;
                m2SubGraphSet.remove(subGraphCandidate);
                break;
            }
            if (matched) continue;
            rdfdiff.printNonMatchingSubGraph(prefix, subGraph);
        }
    }

    private static void printNonMatchingSubGraph(String prefix, Model subGraph) {
        StmtIterator sIter = subGraph.listStatements();
        while (sIter.hasNext()) {
            System.out.print(prefix);
            System.out.println(((Statement)sIter.next()).toString());
        }
    }

    private static void addToSubGraph(Statement stmt, Map<AnonId, Model> subGraphs) {
        HashSet<AnonId> ids = new HashSet<AnonId>();
        rdfdiff.addToIdList(stmt, ids);
        Model subGraph = null;
        for (AnonId id : ids) {
            if (subGraphs.containsKey(id)) continue;
            subGraph = Closure.closure((Statement)stmt);
            subGraph.add(stmt);
            break;
        }
        if (subGraph == null) {
            return;
        }
        StmtIterator sIter = subGraph.listStatements();
        while (sIter.hasNext()) {
            rdfdiff.addToIdList((Statement)sIter.next(), ids);
        }
        for (AnonId id : ids) {
            if (subGraphs.containsKey(id)) {
                throw new IllegalStateException(String.format("ID %s occurs in multiple sub-graphs", id));
            }
            subGraphs.put(id, subGraph);
        }
    }

    private static void addToIdList(Statement stmt, Set<AnonId> ids) {
        if (stmt.getSubject().isAnon()) {
            ids.add(stmt.getSubject().getId());
        }
        if (stmt.getObject().isAnon()) {
            ids.add(stmt.getObject().asResource().getId());
        }
    }

    protected static void usage() {
        System.err.println("usage:");
        System.err.println("    java jena.rdfdiff source1 source2 [lang1 [lang2 [base1 [base2]]]]");
        System.err.println();
        System.err.println("    source1 and source2 can be URL's or filenames");
        System.err.println("    lang1 and lang2 can take values:");
        System.err.println("      RDF/XML");
        System.err.println("      N-TRIPLE");
        System.err.println("      TTL");
        System.err.println("    lang1 defaults to RDF/XML, lang2 to N-TRIPLE");
        System.err.println("    base1 and base2 are URIs");
        System.err.println("    base1 defaults to null");
        System.err.println("    base2 defaults to base1");
        System.err.println("    If no base URIs are specified Jena determines the base URI based on the input source");
        System.err.println();
    }

    protected static void read(Model model, String in, String lang, String base) throws FileNotFoundException {
        try {
            URL url = new URL(in);
            model.read(in, base, lang);
        }
        catch (MalformedURLException e) {
            model.read((InputStream)new FileInputStream(in), base, lang);
        }
    }

    static {
        LogCtl.setLogging();
    }

    private static class ModelReferenceComparator
    implements Comparator<Model> {
        private ModelReferenceComparator() {
        }

        @Override
        public int compare(Model o1, Model o2) {
            int h2;
            if (o1 == o2) {
                return 0;
            }
            int h1 = System.identityHashCode(o1);
            if (h1 == (h2 = System.identityHashCode(o2))) {
                return 0;
            }
            return h1 < h2 ? -1 : 1;
        }
    }
}

