/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query;

import java.util.List;
import java.util.Objects;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.impl.WrappedGraph;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.GraphView;
import org.apache.jena.sparql.engine.Plan;
import org.apache.jena.sparql.engine.QueryEngineFactory;
import org.apache.jena.sparql.engine.QueryEngineRegistry;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingLib;
import org.apache.jena.sparql.engine.binding.BindingRoot;
import org.apache.jena.sparql.exec.QueryExecDataset;
import org.apache.jena.sparql.exec.QueryExecDatasetBuilder;
import org.apache.jena.sparql.exec.QueryExecutionCompat;
import org.apache.jena.sparql.exec.http.QueryExecutionHTTP;
import org.apache.jena.sparql.exec.http.QueryExecutionHTTPBuilder;
import org.apache.jena.sparql.graph.GraphWrapper;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.util.Context;

public class QueryExecutionFactory {
    protected QueryExecutionFactory() {
    }

    public static QueryExecution create(Query query) {
        QueryExecutionFactory.checkArg(query);
        return QueryExecutionFactory.make(query);
    }

    public static QueryExecution create(String queryStr) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr));
    }

    public static QueryExecution create(String queryStr, Syntax syntax) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr, syntax));
    }

    public static QueryExecution create(Query query, Dataset dataset) {
        return QueryExecutionFactory.make(query, dataset, null, null);
    }

    public static QueryExecution create(Query query, DatasetGraph datasetGraph) {
        Objects.requireNonNull(query, "Query is null");
        Objects.requireNonNull(datasetGraph, "DatasetGraph is null");
        return QueryExecutionFactory.make(query, null, datasetGraph, null);
    }

    public static QueryExecution create(String queryStr, Dataset dataset) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.make(QueryExecutionFactory.makeQuery(queryStr), dataset, null, null);
    }

    public static QueryExecution create(String queryStr, Syntax syntax, Dataset dataset) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.make(QueryExecutionFactory.makeQuery(queryStr, syntax), dataset, null, null);
    }

    public static QueryExecution create(Query query, Model model) {
        QueryExecutionFactory.checkArg(query);
        QueryExecutionFactory.checkArg(model);
        return QueryExecutionFactory.make(query, model);
    }

    public static QueryExecution create(String queryStr, Model model) {
        QueryExecutionFactory.checkArg(queryStr);
        QueryExecutionFactory.checkArg(model);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr), model);
    }

    public static QueryExecution create(String queryStr, Syntax lang, Model model) {
        QueryExecutionFactory.checkArg(queryStr);
        QueryExecutionFactory.checkArg(model);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr, lang), model);
    }

    @Deprecated
    public static QueryExecution create(Query query, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(query);
        QueryExecution qe = QueryExecutionFactory.make(query, null, initialBinding);
        return qe;
    }

    @Deprecated
    public static QueryExecution create(String queryStr, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr), initialBinding);
    }

    public static QueryExecution create(String queryStr, Syntax syntax, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr, syntax), initialBinding);
    }

    @Deprecated
    public static QueryExecution create(Query query, Model model, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(model);
        return QueryExecutionFactory.create(query, DatasetFactory.wrap(model), initialBinding);
    }

    public static QueryExecution create(String queryStr, Model model, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(queryStr);
        QueryExecutionFactory.checkArg(model);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr), model, initialBinding);
    }

    @Deprecated
    public static QueryExecution create(String queryStr, Syntax syntax, Model model, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr, syntax), model, initialBinding);
    }

    public static QueryExecution create(Query query, Dataset dataset, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(query);
        return QueryExecutionFactory.make(query, dataset, initialBinding);
    }

    @Deprecated
    public static QueryExecution create(String queryStr, Dataset dataset, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr), dataset, initialBinding);
    }

    @Deprecated
    public static QueryExecution create(String queryStr, Syntax syntax, Dataset dataset, QuerySolution initialBinding) {
        QueryExecution.create();
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr, syntax), dataset, initialBinding);
    }

    @Deprecated
    public static QueryExecutionHTTP sparqlService(String serviceURL, Query query) {
        return (QueryExecutionHTTP)((QueryExecutionHTTPBuilder)QueryExecution.service(serviceURL).query(query)).build();
    }

    @Deprecated
    public static QueryExecutionHTTP sparqlService(String serviceURL, String query) {
        return (QueryExecutionHTTP)((QueryExecutionHTTPBuilder)QueryExecution.service(serviceURL).query(query)).build();
    }

    @Deprecated
    public static QueryExecution sparqlService(String serviceURL, String query, String defaultGraph) {
        return QueryExecutionFactory.sparqlService(serviceURL, query, List.of(defaultGraph), null);
    }

    @Deprecated
    public static QueryExecutionHTTP sparqlService(String serviceURL, Query query, List<String> defaultGraphURIs, List<String> namedGraphURIs) {
        return QueryExecutionFactory.sparqlService(serviceURL, query.toString(), defaultGraphURIs, namedGraphURIs);
    }

    @Deprecated
    public static QueryExecutionHTTP sparqlService(String serviceURL, String query, List<String> defaultGraphURIs, List<String> namedGraphURIs) {
        QueryExecutionHTTPBuilder builder = QueryExecutionFactory.createExecutionHTTP(serviceURL, query);
        if (defaultGraphURIs != null) {
            defaultGraphURIs.forEach(builder::addDefaultGraphURI);
        }
        if (namedGraphURIs != null) {
            namedGraphURIs.forEach(builder::addNamedGraphURI);
        }
        return (QueryExecutionHTTP)builder.build();
    }

    @Deprecated
    public static QueryExecutionHTTP sparqlService(String serviceURL, Query query, String defaultGraph) {
        return QueryExecutionFactory.sparqlService(serviceURL, query.toString(), List.of(defaultGraph), null);
    }

    @Deprecated
    public static QueryExecutionHTTPBuilder createServiceRequest(String service, Query query) {
        return QueryExecutionFactory.createExecutionHTTP(service, query.toString());
    }

    private static QueryExecutionHTTPBuilder createExecutionHTTP(String serviceURL, String queryStr) {
        return (QueryExecutionHTTPBuilder)((QueryExecutionHTTPBuilder)QueryExecutionHTTP.create().endpoint(serviceURL)).queryString(queryStr);
    }

    public static Plan createPlan(Query query, DatasetGraph dataset, Binding input, Context context2) {
        return QueryExecutionFactory.makePlan(query, dataset, input, context2);
    }

    public static Plan createPlan(Query query, DatasetGraph dataset, Binding input) {
        return QueryExecutionFactory.makePlan(query, dataset, input, null);
    }

    private static Query toQuery(Element pattern) {
        Query query = QueryFactory.make();
        query.setQueryPattern(pattern);
        query.setQuerySelectType();
        query.setQueryResultStar(true);
        return query;
    }

    private static Plan makePlan(Query query, DatasetGraph dataset, Binding input, Context context2) {
        QueryEngineFactory f;
        if (context2 == null) {
            context2 = new Context(ARQ.getContext());
        }
        if (input == null) {
            input = BindingRoot.create();
        }
        if ((f = QueryEngineRegistry.findFactory(query, dataset, context2)) == null) {
            return null;
        }
        return f.create(query, dataset, input, context2);
    }

    private static Query makeQuery(String queryStr) {
        return QueryFactory.create(queryStr);
    }

    private static Query makeQuery(String queryStr, Syntax syntax) {
        return QueryFactory.create(queryStr, syntax);
    }

    protected static QueryExecution make(Query query) {
        return QueryExecution.create().query(query).build();
    }

    protected static QueryExecution make(Query query, Model model) {
        Graph graph = model.getGraph();
        DatasetGraph dataset = DatasetGraphFactory.wrap(graph);
        Graph g = QueryExecutionFactory.unwrap(graph);
        if (g instanceof GraphView) {
            GraphView gv = (GraphView)g;
            dataset.getContext().putAll(gv.getDataset().getContext());
        }
        return QueryExecutionFactory.make(query, null, dataset, null);
    }

    private static Graph unwrap(Graph graph) {
        while (true) {
            if (graph instanceof GraphWrapper) {
                graph = ((GraphWrapper)graph).get();
                continue;
            }
            if (!(graph instanceof WrappedGraph)) break;
            graph = ((WrappedGraph)graph).getWrapped();
        }
        return graph;
    }

    private static QueryExecution make(Query query, Dataset dataset, QuerySolution initialBinding) {
        Binding binding = null;
        if (initialBinding != null) {
            binding = BindingLib.toBinding(initialBinding);
        }
        return QueryExecutionFactory.make(query, dataset, null, binding);
    }

    private static QueryExecution make(Query query, Dataset dataset, DatasetGraph datasetGraph, Binding initialBinding) {
        QueryExecDatasetBuilder builder = QueryExecDataset.newBuilder().query(query);
        if (initialBinding != null) {
            builder.initialBinding(initialBinding);
        }
        if (dataset == null && datasetGraph == null) {
            return QueryExecutionCompat.compatibility(builder, null, query, builder.getQueryString());
        }
        if (dataset == null) {
            builder.dataset(datasetGraph);
            dataset = DatasetFactory.wrap(datasetGraph);
        } else {
            builder.dataset(dataset.asDatasetGraph());
        }
        return QueryExecutionCompat.compatibility(builder, dataset, query, builder.getQueryString());
    }

    private static void checkArg(Model model) {
        Objects.requireNonNull(model, "Model is a null pointer");
    }

    private static void checkArg(String queryStr) {
        Objects.requireNonNull(queryStr, "Query string is null");
    }

    private static void checkArg(Query query) {
        Objects.requireNonNull(query, "Query is null");
    }
}

