/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.cmd;

import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.Version;
import org.apache.jena.cmd.ArgDecl;
import org.apache.jena.cmd.CmdArgModule;
import org.apache.jena.cmd.CmdGeneral;
import org.apache.jena.cmd.ModBase;

public class ModVersion
extends ModBase {
    protected final ArgDecl versionDecl = new ArgDecl(false, "version");
    protected boolean version = false;
    protected boolean printAndExit = false;
    private Version versionMgr = new Version();

    public ModVersion(boolean printAndExit) {
        this.printAndExit = printAndExit;
    }

    public void addClass(Class<?> c) {
        this.versionMgr.addClass(c);
    }

    @Override
    public void registerWith(CmdGeneral cmdLine) {
        cmdLine.add(this.versionDecl, "--version", "Version information");
    }

    @Override
    public void processArgs(CmdArgModule cmdLine) {
        if (cmdLine.contains(this.versionDecl)) {
            this.version = true;
        }
        if (this.version && this.printAndExit) {
            this.printVersionAndExit();
        }
    }

    public boolean getVersionFlag() {
        return this.version;
    }

    public void printVersion() {
        this.versionMgr.print(IndentedWriter.stdout);
    }

    public void printVersionAndExit() {
        this.printVersion();
        System.exit(0);
    }
}

