/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.pfunction.library;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.QueryBuildException;
import org.apache.jena.rdf.model.impl.Util;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.pfunction.PFuncSimpleAndList;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.util.IterLib;

public class strSplit
extends PFuncSimpleAndList {
    @Override
    public void build(PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        super.build(argSubject, predicate, argObject, execCxt);
        if (argObject.getArgListSize() != 2) {
            throw new QueryBuildException("Object list must contain exactly two arguments, the string to split and a regular expression");
        }
    }

    @Override
    public QueryIterator execEvaluated(Binding binding, Node subject, Node predicate, PropFuncArg object, ExecutionContext execCxt) {
        if (!object.getArg(0).isLiteral() || !object.getArg(1).isLiteral()) {
            return IterLib.noResults(execCxt);
        }
        String s = object.getArg(0).getLiteralLexicalForm();
        String regex = object.getArg(1).getLiteralLexicalForm();
        List<String> tokens = Arrays.asList(StrUtils.split((String)s, (String)regex));
        if (Var.isVar(subject)) {
            Var subjectVar = Var.alloc(subject);
            Iterator it = Iter.map(tokens.iterator(), item -> BindingFactory.binding(binding, subjectVar, NodeFactory.createLiteral((String)item)));
            return QueryIterPlainWrapper.create(it, execCxt);
        }
        if (Util.isSimpleString((Node)subject)) {
            if (tokens.contains(subject.getLiteralLexicalForm())) {
                return IterLib.result(binding, execCxt);
            }
            return IterLib.noResults(execCxt);
        }
        return IterLib.noResults(execCxt);
    }
}

