/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.protobuf;

import org.apache.jena.graph.Triple;
import org.apache.jena.riot.protobuf.ProtobufConvert;
import org.apache.jena.riot.protobuf.VisitorStreamRowProtoRDF;
import org.apache.jena.riot.protobuf.wire.PB_RDF;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.core.Quad;

public class Protobuf2StreamRDF
implements VisitorStreamRowProtoRDF {
    private final StreamRDF dest;
    private final PrefixMap pmap;

    public Protobuf2StreamRDF(PrefixMap pmap, StreamRDF stream) {
        this.pmap = pmap;
        this.dest = stream;
    }

    @Override
    public void visit(PB_RDF.RDF_Triple rt) {
        Triple t = ProtobufConvert.convert(rt, this.pmap);
        this.dest.triple(t);
    }

    @Override
    public void visit(PB_RDF.RDF_Quad rq) {
        Quad q = ProtobufConvert.convert(rq, this.pmap);
        this.dest.quad(q);
    }

    @Override
    public void visit(PB_RDF.RDF_PrefixDecl prefixDecl) {
        String prefix = prefixDecl.getPrefix();
        String iriStr = prefixDecl.getUri();
        this.pmap.add(prefix, iriStr);
        this.dest.prefix(prefix, iriStr);
    }

    @Override
    public void visit(PB_RDF.RDF_IRI baseDecl) {
        String iriStr = baseDecl.getIri();
        this.dest.base(iriStr);
    }
}

