/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfs.engine;

import java.util.Set;
import org.apache.jena.rdfs.engine.CxtInf;
import org.apache.jena.rdfs.engine.MapperX;
import org.apache.jena.rdfs.engine.Output;
import org.apache.jena.rdfs.setup.ConfigRDFS;

public class ApplyRDFS<X, T>
extends CxtInf<X, T> {
    private static final boolean SHORT_CIRCUIT = true;

    public ApplyRDFS(ConfigRDFS<X> setup, MapperX<X, T> mapper) {
        super(setup, mapper);
    }

    public void infer(T tuple, Output<X> out) {
        this.infer(this.mapper.subject(tuple), this.mapper.predicate(tuple), this.mapper.object(tuple), out);
    }

    public void infer(X s, X p, X o, Output<X> out) {
        if (!this.setup.hasRDFS()) {
            return;
        }
        this.subClass(s, p, o, out);
        this.subProperty(s, p, o, out);
        this.domain(s, p, o, out);
        this.range(s, p, o, out);
    }

    private void derive(X s, X p, X o, Output<X> out) {
        out.action(s, p, o);
    }

    private void subClass(X s, X p, X o, Output<X> out) {
        if (!this.setup.hasClassDeclarations()) {
            return;
        }
        if (p.equals(this.rdfType)) {
            Set<X> x = this.setup.getSuperClasses(o);
            x.forEach(c -> this.derive(s, this.rdfType, c, out));
        }
    }

    private void subProperty(X s, X p, X o, Output<X> out) {
        if (!this.setup.hasClassDeclarations()) {
            return;
        }
        Set<X> x = this.setup.getSuperProperties(p);
        x.forEach(p2 -> this.derive(s, p2, o, out));
    }

    private final void domain(X s, X p, X o, Output<X> out) {
        if (!this.setup.hasDomainDeclarations()) {
            return;
        }
        Set<X> x = this.setup.getDomain(p);
        x.forEach(c -> {
            this.derive(s, this.rdfType, c, out);
            this.subClass(s, this.rdfType, c, out);
        });
    }

    private final void range(X s, X p, X o, Output<X> out) {
        if (!this.setup.hasRangeDeclarations()) {
            return;
        }
        Set<X> x = this.setup.getRange(p);
        x.forEach(c -> {
            this.derive(o, this.rdfType, c, out);
            this.subClass(o, this.rdfType, c, out);
        });
    }
}

