/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.sse.builders;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.graph.NodeConst;
import org.apache.jena.sparql.sse.Item;
import org.apache.jena.sparql.sse.ItemList;
import org.apache.jena.sparql.sse.ItemLocation;
import org.apache.jena.sparql.sse.builders.BuilderLib;

public class BuilderNode {
    public static Node buildNode(Item item) {
        if (item.isSymbol("true")) {
            return NodeConst.nodeTrue;
        }
        if (item.isSymbol("false")) {
            return NodeConst.nodeFalse;
        }
        if (item.isSymbolIgnoreCase("ANY") || item.isSymbol("_")) {
            return Node.ANY;
        }
        if (!item.isNode()) {
            BuilderLib.broken((ItemLocation)item, "Not a node", item);
        }
        return item.getNode();
    }

    public static List<Node> buildNodeList(Item item) {
        BuilderLib.checkList(item);
        ItemList list = item.getList();
        return BuilderNode.buildNodeList(list);
    }

    public static List<Node> buildNodeList(ItemList list) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Item item : list) {
            Node v = BuilderNode.buildNode(item);
            nodes.add(v);
        }
        return nodes;
    }

    public static Var buildVar(Item item) {
        if (!item.isNode() || !Var.isVar(item.getNode())) {
            BuilderLib.broken((ItemLocation)item, "Not a variable", item);
        }
        return Var.alloc(item.getNode());
    }

    public static List<Var> buildVarList(Item item) {
        BuilderLib.checkList(item);
        ItemList list = item.getList();
        return BuilderNode.buildVarList(list);
    }

    public static List<Var> buildVarList(ItemList list) {
        if (list.size() > 0 && list.getFirst().isSymbol("vars")) {
            list = list.cdr();
        }
        ArrayList<Var> vars = new ArrayList<Var>();
        for (Item x : list) {
            Var v = BuilderNode.buildVar(x);
            vars.add(v);
        }
        return vars;
    }

    public static String buildSymbol(Item item) {
        if (!item.isSymbol()) {
            BuilderLib.broken((ItemLocation)item, "Not a symbol", item);
        }
        return item.getSymbol();
    }

    public static List<Var> buildVars(ItemList list) {
        list = BuilderLib.skipTag(list, "vars");
        ArrayList<Var> x = new ArrayList<Var>();
        for (int i = 0; i < list.size(); ++i) {
            Item item = list.get(i);
            Var var = BuilderNode.buildVar(item);
            x.add(Var.alloc(item.getNode()));
        }
        return x;
    }

    private static BigInteger buildInteger(Item item, boolean allowDefault) {
        NodeValue nv;
        Node node;
        if (allowDefault && item.equals(Item.defaultItem)) {
            return null;
        }
        if (!item.isNode()) {
            BuilderLib.broken(item, "Not an integer: " + item);
        }
        if (!(node = item.getNode()).isLiteral()) {
            BuilderLib.broken(item, "Not an integer: " + item);
        }
        if (!(nv = NodeValue.makeNode(node)).isInteger()) {
            BuilderLib.broken(item, "Not an integer: " + item);
        }
        return nv.getInteger();
    }

    public static long buildLong(Item item) {
        BigInteger i = BuilderNode.buildInteger(item, false);
        return i.longValue();
    }

    public static long buildLong(Item item, int dft) {
        BigInteger i = BuilderNode.buildInteger(item, true);
        if (i == null) {
            return dft;
        }
        return i.longValue();
    }

    public static long buildLong(ItemList list, int idx) {
        return BuilderNode.buildLong(list.get(idx));
    }

    public static long buildLong(ItemList list, int idx, int dft) {
        return BuilderNode.buildLong(list.get(idx), dft);
    }

    public static int buildInt(Item item) {
        BigInteger i = BuilderNode.buildInteger(item, false);
        return i.intValue();
    }

    public static int buildInt(Item item, int dft) {
        BigInteger i = BuilderNode.buildInteger(item, true);
        if (i == null) {
            return dft;
        }
        return i.intValue();
    }

    public static int buildInt(ItemList list, int idx) {
        return BuilderNode.buildInt(list.get(idx));
    }

    public static int buildInt(ItemList list, int idx, int dft) {
        return BuilderNode.buildInt(list.get(idx), dft);
    }
}

