/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfs.setup;

import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdfs.engine.ConstRDFS;
import org.apache.jena.rdfs.engine.Match;
import org.apache.jena.rdfs.setup.ConfigRDFS;

public class MatchVocabRDFS
implements Match<Node, Triple> {
    private final ConfigRDFS<Node> setup;

    public MatchVocabRDFS(ConfigRDFS<Node> setup) {
        this.setup = setup;
    }

    private static Node nullToAny(Node n) {
        return n == null ? Node.ANY : n;
    }

    @Override
    public Stream<Triple> match(Node s, Node p, Node o) {
        Node sx = MatchVocabRDFS.nullToAny(s);
        Node px = MatchVocabRDFS.nullToAny(p);
        Node ox = MatchVocabRDFS.nullToAny(o);
        return this.match2(MatchVocabRDFS.nullToAny(s), MatchVocabRDFS.nullToAny(p), MatchVocabRDFS.nullToAny(o));
    }

    private Stream<Triple> match2(Node s, Node p, Node o) {
        Map<Node, Set<Node>> map;
        if (p == Node.ANY) {
            Stream<Triple> stream = this.match(s, ConstRDFS.rdfsSubClassOf, o);
            stream = Stream.concat(stream, this.match(s, ConstRDFS.rdfsSubPropertyOf, o));
            stream = Stream.concat(stream, this.match(s, ConstRDFS.rdfsDomain, o));
            stream = Stream.concat(stream, this.match(s, ConstRDFS.rdfsRange, o));
            return stream;
        }
        if (o.isConcrete() && !s.isConcrete()) {
            Set<Node> set;
            if (p.equals((Object)ConstRDFS.rdfsSubClassOf)) {
                set = this.setup.getSubClassesInc(o);
            } else if (p.equals((Object)ConstRDFS.rdfsSubPropertyOf)) {
                set = this.setup.getSubPropertiesInc(o);
            } else if (p.equals((Object)ConstRDFS.rdfsDomain)) {
                set = this.setup.getPropertiesByDomain(o);
            } else if (p.equals((Object)ConstRDFS.rdfsRange)) {
                set = this.setup.getPropertiesByRange(o);
            } else {
                return Stream.empty();
            }
            return set.stream().map(x -> Triple.create((Node)x, (Node)p, (Node)o));
        }
        if (p.equals((Object)ConstRDFS.rdfsSubClassOf)) {
            map = this.setup.getSubClassHierarchy();
        } else if (p.equals((Object)ConstRDFS.rdfsSubPropertyOf)) {
            map = this.setup.getSubPropertyHierarchy();
        } else if (p.equals((Object)ConstRDFS.rdfsDomain)) {
            map = this.setup.getPropertyDomains();
        } else if (p.equals((Object)ConstRDFS.rdfsRange)) {
            map = this.setup.getPropertyRanges();
        } else {
            return Stream.empty();
        }
        if (s.isConcrete()) {
            Set<Node> x2 = map.get(s);
            if (x2 == null) {
                return Stream.empty();
            }
            if (o.isConcrete()) {
                return x2.contains(o) ? Stream.of(Triple.create((Node)s, (Node)p, (Node)o)) : Stream.empty();
            }
            return x2.stream().map(ox -> Triple.create((Node)s, (Node)p, (Node)ox));
        }
        return map.entrySet().stream().flatMap(e2 -> ((Set)e2.getValue()).stream().map(obj -> Triple.create((Node)((Node)e2.getKey()), (Node)p, (Node)obj)));
    }
}

