/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfs;

import java.util.Iterator;
import java.util.stream.Stream;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.IteratorOnClose;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdfs.GraphRDFS;
import org.apache.jena.rdfs.SetupRDFS;
import org.apache.jena.rdfs.engine.InfFindQuad;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphWrapper;
import org.apache.jena.sparql.core.DatasetGraphWrapperView;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.util.Context;

public class DatasetGraphRDFS
extends DatasetGraphWrapper
implements DatasetGraphWrapperView {
    private final SetupRDFS setup;

    public DatasetGraphRDFS(DatasetGraph dsg, SetupRDFS setup) {
        super(dsg);
        this.setup = setup;
    }

    public DatasetGraphRDFS(DatasetGraph dsg, SetupRDFS setup, Context cxt) {
        super(dsg, cxt);
        this.setup = setup;
    }

    @Override
    public Graph getDefaultGraph() {
        Graph base = this.getG().getDefaultGraph();
        return new GraphRDFS(base, this.setup);
    }

    @Override
    public Graph getUnionGraph() {
        Graph base = this.getG().getUnionGraph();
        return new GraphRDFS(base, this.setup);
    }

    @Override
    public Graph getGraph(Node graphNode) {
        Graph base = this.getG().getGraph(graphNode);
        if (base == null) {
            return null;
        }
        return new GraphRDFS(base, this.setup);
    }

    @Override
    public Iterator<Quad> find(Quad quad) {
        return this.find(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    @Override
    public Iterator<Quad> find(Node g, Node s, Node p, Node o) {
        Iterator<Quad> iter;
        if (g == null) {
            g = Quad.defaultGraphIRI;
        }
        if ((iter = this.findInf(g, s, p, o)) == null) {
            return Iter.nullIterator();
        }
        return iter;
    }

    private Iterator<Quad> findInf(Node g, Node s, Node p, Node o) {
        InfFindQuad infMatcher = new InfFindQuad(this.setup, g, this.getR());
        Stream quads = infMatcher.match(s, p, o);
        IteratorOnClose iter = quads.iterator();
        iter = Iter.onClose(iter, () -> quads.close());
        return iter;
    }

    @Override
    public Iterator<Quad> findNG(Node g, Node s, Node p, Node o) {
        if (Quad.isDefaultGraph(g)) {
            throw new IllegalArgumentException("Default graph is findNG call");
        }
        if (g == null) {
            g = Node.ANY;
        }
        Iterator iter = this.findInf(g, s, p, o);
        if (g == Node.ANY) {
            iter = Iter.filter(this.findInf(g, s, p, o), q -> !q.isDefaultGraph());
        }
        return iter;
    }

    @Override
    public boolean contains(Quad quad) {
        return this.contains(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    @Override
    public boolean contains(Node g, Node s, Node p, Node o) {
        return this.getR().contains(g, s, p, o);
    }
}

