/*
 * Decompiled with CFR 0.152.
 */
package jena;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFReaderI;
import org.apache.jena.rdf.model.RDFWriterI;
import org.apache.jena.shared.JenaException;

public class rdfcopy {
    public static void main(String ... args) {
        int j;
        if (args.length < 1 || "-h".equals(args[0])) {
            rdfcopy.usage();
            System.exit(-1);
        }
        String in = args[0];
        String inlang = "RDF/XML";
        for (j = 1; j < args.length && args[j].contains("="); ++j) {
        }
        int lastInProp = j;
        if (j < args.length) {
            inlang = args[j];
        }
        ++j;
        String outlang = "N-TRIPLE";
        while (j < args.length && args[j].contains("=")) {
            ++j;
        }
        int lastOutProp = j;
        if (j < args.length) {
            outlang = args[j];
        }
        if (j + 1 < args.length) {
            rdfcopy.usage();
            System.exit(-1);
        }
        try {
            Model m = ModelFactory.createDefaultModel();
            Object base = in;
            RDFReaderI rdr = m.getReader(inlang);
            for (j = 1; j < lastInProp; ++j) {
                int eq = args[j].indexOf("=");
                rdr.setProperty(args[j].substring(0, eq), (Object)args[j].substring(eq + 1));
            }
            try {
                rdr.read(m, in);
            }
            catch (JenaException ex) {
                if (!(ex.getCause() instanceof MalformedURLException)) {
                    throw ex;
                }
                File f = new File(in);
                base = "file:///" + f.getCanonicalPath().replace('\\', '/');
                rdr.read(m, (InputStream)new FileInputStream(in), (String)base);
            }
            RDFWriterI w = m.getWriter(outlang);
            ++j;
            while (j < lastOutProp) {
                int eq = args[j].indexOf("=");
                w.setProperty(args[j].substring(0, eq), (Object)args[j].substring(eq + 1));
                ++j;
            }
            w.write(m, (OutputStream)System.out, null);
            System.exit(0);
        }
        catch (Exception e) {
            System.err.println("Unhandled exception:");
            System.err.println("    " + e.toString());
            System.exit(-1);
        }
    }

    protected static void usage() {
        System.err.println("usage:");
        System.err.println("    java jena.rdfcopy in {inprop=inval}* [ inlang  {outprop=outval}* outlang]]");
        System.err.println();
        System.err.println("    in can be a URL or a filename");
        System.err.println("    inlang and outlang can take values:");
        System.err.println("      RDF/XML");
        System.err.println("      RDF/XML-ABBREV");
        System.err.println("      N-TRIPLE");
        System.err.println("      TURTLE");
        System.err.println("      N3");
        System.err.println("    inlang defaults to RDF/XML, outlang to N-TRIPLE");
        System.err.println("    The legal values for inprop and outprop depend on inlang and outlang.");
        System.err.println("    The legal values for inval and outval depend on inprop and outprop.");
        System.err.println();
    }

    protected static void read(Model model, String in, String lang) throws FileNotFoundException {
        try {
            URL url = new URL(in);
            model.read(in, lang);
        }
        catch (MalformedURLException e) {
            model.read((InputStream)new FileInputStream(in), "", lang);
        }
    }

    static {
        LogCtl.setLogging();
    }
}

