/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.xloader0;

import org.apache.jena.atlas.lib.tuple.TupleMap;
import org.apache.jena.dboe.base.file.FileSet;
import org.apache.jena.dboe.base.file.Location;
import org.apache.jena.dboe.base.record.RecordFactory;
import org.apache.jena.dboe.index.RangeIndex;
import org.apache.jena.dboe.trans.bplustree.BPlusTree;
import org.apache.jena.dboe.trans.bplustree.BPlusTreeFactory;
import org.apache.jena.dboe.transaction.txn.ComponentId;
import org.apache.jena.tdb2.store.tupletable.TupleIndex;
import org.apache.jena.tdb2.store.tupletable.TupleIndexRecord;

public class BulkLoaderX0 {
    public static int DataTick = 1000000;
    public static int DataSuperTick = 10;

    public static TupleIndex openTupleIndex(Location location, String indexName, String primary, String indexOrder, int keyLength, int valueLength) {
        TupleMap cmap = TupleMap.create((String)primary, (String)indexOrder);
        RecordFactory rf = new RecordFactory(8 * cmap.length(), 0);
        RangeIndex rIdx = BulkLoaderX0.makeRangeIndex(location, rf, indexName);
        TupleIndexRecord tIdx = new TupleIndexRecord(primary.length(), cmap, indexName, rf, rIdx);
        return tIdx;
    }

    public static RangeIndex makeRangeIndex(Location location, RecordFactory recordFactory, String name) {
        ComponentId cid = null;
        FileSet fs = new FileSet(location, name);
        BPlusTree bpt = BPlusTreeFactory.createBPTree(cid, (FileSet)fs, (RecordFactory)recordFactory);
        return bpt;
    }
}

