/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.xloader;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.json.JSON;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.atlas.json.JsonValue;
import org.apache.jena.atlas.lib.BitsLong;
import org.apache.jena.atlas.lib.DateTimeUtils;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.lib.Timer;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.dboe.base.file.Location;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.irix.IRIProvider;
import org.apache.jena.irix.SystemIRIx;
import org.apache.jena.riot.system.AsyncParser;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.system.progress.ProgressMonitor;
import org.apache.jena.system.progress.ProgressMonitorOutput;
import org.apache.jena.tdb2.DatabaseMgr;
import org.apache.jena.tdb2.solver.stats.Stats;
import org.apache.jena.tdb2.solver.stats.StatsCollectorNodeId;
import org.apache.jena.tdb2.store.DatasetGraphTDB;
import org.apache.jena.tdb2.store.NodeId;
import org.apache.jena.tdb2.store.nodetable.NodeTable;
import org.apache.jena.tdb2.store.nodetupletable.NodeTupleTable;
import org.apache.jena.tdb2.store.value.DoubleNode62;
import org.apache.jena.tdb2.sys.TDBInternal;
import org.apache.jena.tdb2.xloader.BulkLoaderX;
import org.apache.jena.tdb2.xloader.WriteRows;
import org.apache.jena.tdb2.xloader.XLoaderFiles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcIngestDataX {
    private static Logger LOG = LoggerFactory.getLogger((String)"Data");

    public static void exec(String location, XLoaderFiles loaderFiles, List<String> datafiles, boolean collectStats) {
        IRIProvider provider = SystemIRIx.getProvider();
        DatasetGraph dsg = DatabaseMgr.connectDatasetGraph(location);
        ProgressMonitorOutput monitor = ProgressMonitorOutput.create((Logger)LOG, (String)"Data", (long)BulkLoaderX.DataTick, (int)BulkLoaderX.DataSuperTick);
        OutputStream outputTriples = IO.openOutputFile((String)loaderFiles.triplesFile);
        OutputStream outputQuads = IO.openOutputFile((String)loaderFiles.quadsFile);
        OutputStream outT = outputTriples;
        OutputStream outQ = outputQuads;
        dsg.executeWrite(() -> ProcIngestDataX.lambda$exec$2(dsg, (ProgressMonitor)monitor, outT, outQ, datafiles, loaderFiles));
        TDBInternal.expel(dsg);
        SystemIRIx.setProvider((IRIProvider)provider);
    }

    private static Pair<Long, Long> build(DatasetGraph dsg, ProgressMonitor monitor, OutputStream outputTriples, OutputStream outputQuads, List<String> datafiles) {
        Location location;
        DatasetGraphTDB dsgtdb = TDBInternal.getDatasetGraphTDB(dsg);
        outputTriples = IO.ensureBuffered((OutputStream)outputTriples);
        outputQuads = IO.ensureBuffered((OutputStream)outputQuads);
        IngestData sink = new IngestData(dsgtdb, monitor, outputTriples, outputQuads, false);
        Timer timer = new Timer();
        timer.startTimer();
        monitor.start();
        sink.startBulk();
        AsyncParser.asyncParse(datafiles, (StreamRDF)sink);
        sink.finishBulk();
        IO.close((Closeable)outputTriples);
        IO.close((Closeable)outputQuads);
        long cTriple = sink.tripleCount();
        long cQuad = sink.quadCount();
        if (sink.getCollector() != null && !(location = dsgtdb.getLocation()).isMem()) {
            Stats.write(location.getPath("stats.opt"), sink.getCollector().results());
        }
        monitor.finish();
        long time = timer.endTimer();
        long total = monitor.getTicks();
        float elapsedSecs = (float)time / 1000.0f;
        float rate = elapsedSecs != 0.0f ? (float)total / elapsedSecs : 0.0f;
        String str = String.format("Total: %,d tuples : %,.2f seconds : %,.2f tuples/sec [%s]", total, Float.valueOf(elapsedSecs), Float.valueOf(rate), DateTimeUtils.nowAsString());
        LOG.info(str);
        return Pair.create((Object)cTriple, (Object)cQuad);
    }

    private static /* synthetic */ void lambda$exec$2(DatasetGraph dsg, ProgressMonitor monitor, OutputStream outT, OutputStream outQ, List datafiles, XLoaderFiles loaderFiles) {
        Pair<Long, Long> p = ProcIngestDataX.build(dsg, monitor, outT, outQ, datafiles);
        String str = DateTimeUtils.nowAsXSDDateTimeString();
        long cTriple = (Long)p.getLeft();
        long cQuad = (Long)p.getRight();
        FmtLog.info((Logger)LOG, (String)"Triples = %,d ; Quads = %,d", (Object[])new Object[]{cTriple, cQuad});
        JsonObject obj = JSON.buildObject(b -> {
            b.pair("ingested", str);
            b.key("data").startArray();
            datafiles.forEach(fn -> b.value(fn));
            b.finishArray();
            b.pair("triples", cTriple);
            b.pair("quads", cQuad);
        });
        try (OutputStream out = IO.openOutputFile((String)loaderFiles.loadInfo);){
            JSON.write((OutputStream)out, (JsonValue)obj);
        }
        catch (IOException ex) {
            IO.exception((IOException)ex);
        }
    }

    static class IngestData
    implements StreamRDF {
        private DatasetGraphTDB dsg;
        private NodeTable nodeTable;
        long countTriples = 0L;
        long countQuads = 0L;
        private WriteRows writerTriples;
        private WriteRows writerQuads;
        private ProgressMonitor monitor;
        private StatsCollectorNodeId stats;

        IngestData(DatasetGraphTDB dsg, ProgressMonitor monitor, OutputStream outputTriples, OutputStream outputQuads, boolean collectStats) {
            this.dsg = dsg;
            this.monitor = monitor;
            NodeTupleTable ntt = dsg.getTripleTable().getNodeTupleTable();
            this.nodeTable = ntt.getNodeTable();
            this.writerTriples = new WriteRows(outputTriples, 3, 100000);
            this.writerQuads = new WriteRows(outputQuads, 4, 100000);
            if (collectStats) {
                this.stats = new StatsCollectorNodeId(this.nodeTable);
            }
        }

        public void startBulk() {
        }

        public void start() {
        }

        public void finish() {
        }

        public void finishBulk() {
            this.writerTriples.flush();
            this.writerQuads.flush();
            this.nodeTable.sync();
        }

        public void triple(Triple triple) {
            ++this.countTriples;
            Node s = triple.getSubject();
            Node p = triple.getPredicate();
            Node o = triple.getObject();
            this.process(Quad.tripleInQuad, s, p, o);
        }

        public void quad(Quad quad) {
            ++this.countQuads;
            Node s = quad.getSubject();
            Node p = quad.getPredicate();
            Node o = quad.getObject();
            Node g = null;
            if (!quad.isTriple() && !quad.isDefaultGraph()) {
                g = quad.getGraph();
            }
            this.process(g, s, p, o);
        }

        private static long encode(NodeId nodeId) {
            long x = nodeId.getPtrLocation();
            switch (nodeId.type()) {
                case PTR: {
                    return x;
                }
                case XSD_DOUBLE: {
                    x = DoubleNode62.insertType(x);
                    return x;
                }
            }
            x = BitsLong.pack((long)x, (long)nodeId.getTypeValue(), (int)56, (int)62);
            x = BitsLong.set((long)x, (int)63);
            return x;
        }

        private void write(WriteRows out, NodeId nodeId) {
            long x = IngestData.encode(nodeId);
            out.write(x);
        }

        private void process(Node g, Node s, Node p, Node o) {
            NodeId sId = this.nodeTable.getAllocateNodeId(s);
            NodeId pId = this.nodeTable.getAllocateNodeId(p);
            NodeId oId = this.nodeTable.getAllocateNodeId(o);
            if (g != null) {
                NodeId gId = this.nodeTable.getAllocateNodeId(g);
                this.write(this.writerQuads, gId);
                this.write(this.writerQuads, sId);
                this.write(this.writerQuads, pId);
                this.write(this.writerQuads, oId);
                this.writerQuads.endOfRow();
                if (this.stats != null) {
                    this.stats.record(gId, sId, pId, oId);
                }
            } else {
                this.write(this.writerTriples, sId);
                this.write(this.writerTriples, pId);
                this.write(this.writerTriples, oId);
                this.writerTriples.endOfRow();
                if (this.stats != null) {
                    this.stats.record((Object)null, sId, pId, oId);
                }
            }
            this.monitor.tick();
        }

        public StatsCollectorNodeId getCollector() {
            return this.stats;
        }

        public long tripleCount() {
            return this.countTriples;
        }

        public long quadCount() {
            return this.countQuads;
        }

        public void base(String base) {
        }

        public void prefix(String prefix, String iri) {
            this.dsg.prefixes().add(prefix, iri);
        }
    }
}

