/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.transaction;

import org.apache.jena.dboe.base.file.Location;
import org.apache.jena.dboe.transaction.Transactional;
import org.apache.jena.dboe.transaction.txn.TransactionCoordinator;
import org.apache.jena.dboe.transaction.txn.TransactionalBase;
import org.apache.jena.dboe.transaction.txn.TransactionalComponent;
import org.apache.jena.dboe.transaction.txn.TransactionalSystem;
import org.apache.jena.dboe.transaction.txn.journal.Journal;

public class TransactionalFactory {
    public static Transactional createTransactional(Location location, TransactionalComponent ... elements) {
        TransactionCoordinator coord = new TransactionCoordinator(location);
        return TransactionalFactory.createTransactional(coord, elements);
    }

    public static Transactional createTransactional(Journal journal, TransactionalComponent ... elements) {
        TransactionCoordinator coord = new TransactionCoordinator(journal);
        return TransactionalFactory.createTransactional(coord, elements);
    }

    private static Transactional createTransactional(TransactionCoordinator coord, TransactionalComponent ... elements) {
        for (TransactionalComponent tc : elements) {
            coord.add(tc);
        }
        TransactionalBase base = new TransactionalBase(coord);
        coord.start();
        return base;
    }

    public static TransactionalSystem createTransactionalSystem(TransactionCoordinator coord) {
        return new TransactionalBase(coord);
    }
}

