/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.base.objectfile;

import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.tdb.base.objectfile.ObjectFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectFileLogger
implements ObjectFile {
    protected final ObjectFile other;
    private static Logger defaultLogger = LoggerFactory.getLogger(ObjectFile.class);
    private final Logger log;
    private final String label;

    public ObjectFileLogger(String label, ObjectFile other) {
        this.other = other;
        this.label = label;
        this.log = defaultLogger;
    }

    @Override
    public long write(ByteBuffer buffer) {
        this.info("write" + buffer);
        return this.other.write(buffer);
    }

    @Override
    public void reposition(long id) {
        this.info("reposition(" + id + ")");
        this.other.reposition(id);
    }

    @Override
    public ByteBuffer read(long id) {
        this.info("read(" + id + ")");
        return this.other.read(id);
    }

    @Override
    public Iterator<Pair<Long, ByteBuffer>> all() {
        this.info("all()");
        return this.other.all();
    }

    @Override
    public void truncate(long size) {
        this.info("truncate(" + size + ")");
        this.other.truncate(size);
    }

    public void sync() {
        this.info("sync");
        this.other.sync();
    }

    public void close() {
        this.info("close");
        this.other.close();
    }

    @Override
    public String getLabel() {
        return this.other.getLabel();
    }

    @Override
    public long length() {
        return this.other.length();
    }

    @Override
    public boolean isEmpty() {
        return this.other.isEmpty();
    }

    private void info(String string) {
        if (this.label != null) {
            string = this.label + ": " + (String)string;
        }
        this.log.info((String)string);
    }
}

