/*
 * Decompiled with CFR 0.152.
 */
package shex;

import java.io.OutputStream;
import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.cmd.ArgDecl;
import org.apache.jena.cmd.CmdException;
import org.apache.jena.cmd.CmdGeneral;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RiotException;
import org.apache.jena.shex.Shex;
import org.apache.jena.shex.ShexException;
import org.apache.jena.shex.ShexMap;
import org.apache.jena.shex.ShexReport;
import org.apache.jena.shex.ShexSchema;
import org.apache.jena.shex.ShexShape;
import org.apache.jena.shex.ShexValidator;
import org.apache.jena.shex.sys.ShexLib;
import org.apache.jena.sys.JenaSystem;

public class shex_validate
extends CmdGeneral {
    private ArgDecl argOutputText = new ArgDecl(false, "--text");
    private ArgDecl argData = new ArgDecl(true, "--data", "--datafile", "-d");
    private ArgDecl argShapes = new ArgDecl(true, "--schema", "--shapes", "--shapesfile", "--shapefile", "-s");
    private ArgDecl argShapeMap = new ArgDecl(true, "--shapesMap", "--shapesmap", "--map", "-m");
    private ArgDecl argTargetNode = new ArgDecl(true, "--target", "--node", "-n");
    private String datafile = null;
    private String shapesfile = null;
    private String mapfile = null;
    private String targetNode = null;
    private boolean textOutput = false;
    static OutputStream output;

    public static void main(String ... argv) {
        new shex_validate(argv).mainRun();
    }

    public shex_validate(String[] argv) {
        super(argv);
        super.add(this.argShapes, "--schema", "Shapes file");
        super.add(this.argData, "--data", "Data file");
        super.add(this.argShapeMap, "--map", "ShEx shapes map");
        super.add(this.argTargetNode, "--target", "Validate specific node [may use prefixes from the data]");
        super.add(this.argOutputText, "--text", "Output in concise text format");
    }

    @Override
    protected String getSummary() {
        return this.getCommandName() + " [--target URI|--map mapsFile] --shapes shapesFile --data dataFile";
    }

    @Override
    protected void processModulesAndArgs() {
        super.processModulesAndArgs();
        this.datafile = super.getValue(this.argData);
        this.shapesfile = super.getValue(this.argShapes);
        if (this.datafile == null && this.shapesfile == null && this.positionals.size() == 1) {
            this.datafile = (String)this.positionals.get(0);
            this.shapesfile = (String)this.positionals.get(0);
        }
        if (this.datafile == null) {
            throw new CmdException("Usage: " + this.getSummary());
        }
        if (this.shapesfile == null) {
            this.shapesfile = this.datafile;
        }
        this.textOutput = super.hasArg(this.argOutputText);
        if (this.contains(this.argTargetNode)) {
            this.targetNode = this.getValue(this.argTargetNode);
        }
        if (this.contains(this.argShapeMap)) {
            this.mapfile = this.getValue(this.argShapeMap);
        }
        if (this.targetNode != null && this.mapfile != null) {
            throw new CmdException("Only one of target node and map file");
        }
        if (this.targetNode == null && this.mapfile == null) {
            throw new CmdException("One of target node and map file required");
        }
    }

    @Override
    protected void exec() {
        Graph dataGraph;
        ShexSchema shapes;
        try {
            shapes = Shex.readSchema((String)this.shapesfile);
        }
        catch (ShexException ex) {
            System.err.println("Failed to read shapes: " + ex.getMessage());
            throw new CmdException();
        }
        try {
            dataGraph = this.load(this.datafile, "data file");
        }
        catch (RiotException ex) {
            throw new CmdException("Failed to data: " + ex.getMessage());
        }
        if (this.mapfile != null) {
            ShexMap map;
            try {
                map = Shex.readShapeMap((String)this.mapfile);
            }
            catch (ShexException ex) {
                throw new CmdException("Failed to read shapes map: " + ex.getMessage());
            }
            ShexReport report = ShexValidator.get().validate(dataGraph, shapes, map);
            ShexLib.printReport((OutputStream)output, (ShexReport)report);
            return;
        }
        ShexShape startShape = shapes.getStart();
        if (startShape == null) {
            throw new CmdException("Start node required for URI-validation");
        }
        String targetURIstr = dataGraph.getPrefixMapping().expandPrefix(this.targetNode);
        Node focus = NodeFactory.createURI((String)targetURIstr);
        ShexReport report = ShexValidator.get().validate(dataGraph, shapes, startShape, focus);
        ShexLib.printReport((OutputStream)output, (ShexReport)report);
    }

    private Graph load(String filename, String scope) {
        try {
            Graph graph = RDFDataMgr.loadGraph((String)filename);
            return graph;
        }
        catch (RiotException ex) {
            System.err.println("Loading " + scope);
            throw ex;
        }
    }

    @Override
    protected String getCommandName() {
        return "shex_validate";
    }

    static {
        LogCtl.setLogging();
        JenaSystem.init();
        output = System.out;
    }
}

