/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.engine.http.Service;
import org.apache.jena.sparql.service.ServiceExecutorFactory;
import org.apache.jena.sparql.util.Context;

public class ServiceExecutorRegistry {
    List<ServiceExecutorFactory> registry = new ArrayList<ServiceExecutorFactory>();
    public static ServiceExecutorFactory httpService = (op, opx, binding, execCxt) -> () -> Service.exec(op, execCxt.getContext());

    public static ServiceExecutorRegistry standardRegistry() {
        ServiceExecutorRegistry reg = ServiceExecutorRegistry.get(ARQ.getContext());
        return reg;
    }

    public static void init() {
        ServiceExecutorRegistry reg = new ServiceExecutorRegistry();
        reg.add(httpService);
        ServiceExecutorRegistry.set(ARQ.getContext(), reg);
    }

    public static ServiceExecutorRegistry get() {
        ServiceExecutorRegistry reg = ServiceExecutorRegistry.get(ARQ.getContext());
        if (reg == null) {
            ServiceExecutorRegistry.init();
            reg = ServiceExecutorRegistry.get(ARQ.getContext());
        }
        return reg;
    }

    public static ServiceExecutorRegistry get(Context context2) {
        if (context2 == null) {
            return null;
        }
        return (ServiceExecutorRegistry)context2.get(ARQConstants.registryServiceExecutors);
    }

    public static void set(Context context2, ServiceExecutorRegistry reg) {
        context2.set(ARQConstants.registryServiceExecutors, reg);
    }

    public ServiceExecutorRegistry add(ServiceExecutorFactory f) {
        Objects.requireNonNull(f);
        this.registry.add(0, f);
        return this;
    }

    public ServiceExecutorRegistry remove(ServiceExecutorFactory f) {
        this.registry.remove(f);
        return this;
    }

    public List<ServiceExecutorFactory> getFactories() {
        return this.registry;
    }
}

