/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.sse;

import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.sse.Item;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.vocabulary.XSD;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestSSE_Forms {
    static PrefixMapping pmap = new PrefixMappingImpl();
    private static PrefixMapping original;

    @BeforeClass
    public static void beforeClass() {
        original = SSE.getPrefixMapRead();
        PrefixMapping pmaptest = new PrefixMappingImpl().setNsPrefixes(original).removeNsPrefix("").removeNsPrefix("ex");
    }

    @AfterClass
    public static void afterClass() {
        SSE.setPrefixMapRead((PrefixMapping)original);
    }

    @Test
    public void testBase_01() {
        Item r = Item.createNode((Node)NodeFactory.createURI((String)"http://example/x"));
        this.testItem("(base <http://example/> <x>)", r);
    }

    @Test
    public void testBase_02() {
        Item r = Item.createNode((Node)NodeFactory.createURI((String)"http://example/x"));
        this.testItem("(base <http://HOST/> (base <http://example/xyz> <x>))", r);
    }

    @Test
    public void testBase_03() {
        Item r = SSE.parse((String)"(1 <http://example/xyz>)", null);
        this.testItem("(base <http://example/> (1 <xyz>))", r);
    }

    @Test
    public void testBase_04() {
        Item r = SSE.parse((String)"(1 <http://example/xyz>)", null);
        this.testItem("(1 (base <http://example/> <xyz>))", r);
    }

    @Test
    public void testBase_05() {
        Item r = SSE.parse((String)"(<http://example/xyz> <http://EXAMPLE/other#foo>)", null);
        this.testItem("((base <http://example/> <xyz>) (base <http://EXAMPLE/other> <#foo>))", r);
    }

    @Test
    public void testBase_06() {
        Item r = SSE.parse((String)"(<http://example/xyz> <http://EXAMPLE/other#foo>)", null);
        this.testItem("(base <http://example/> (<xyz> (base <http://EXAMPLE/other> <#foo>)))", r);
    }

    @Test
    public void testBase_07() {
        Item r = SSE.parse((String)"(<http://example/xyz> <http://EXAMPLE/other#foo>)", null);
        this.testItem("(base <http://EXAMPLE/other#> ((base <http://example/> <xyz>) <#foo>))", r);
    }

    @Test
    public void testPrefix_01() {
        Item r = Item.createNode((Node)NodeFactory.createURI((String)"http://ex/abc"));
        this.testItem("(prefix ((ex: <http://ex/>)) ex:abc)", r);
    }

    @Test
    public void testPrefix_02() {
        Item r = Item.createNode((Node)NodeFactory.createURI((String)"http://EXAMPLE/abc"));
        this.testItem("(prefix ((ex: <http://example/>)) (prefix ((ex: <http://EXAMPLE/>)) ex:abc))", r);
    }

    @Test
    public void testPrefix_03() {
        Item r = SSE.parse((String)"(<http://example/abc>)", null);
        this.testItem("(prefix ((ex: <http://example/>)) (ex:abc))", r);
    }

    @Test
    public void testPrefix_04() {
        Item r = SSE.parse((String)"<http://EXAMPLE/abc>", null);
        this.testItem("(prefix ((x: <http://example/>)) (prefix ((ex: <http://EXAMPLE/>)) ex:abc) )", r);
    }

    @Test
    public void testPrefix_05() {
        Item r = SSE.parse((String)"(<http://example/abc>)", null);
        this.testItem("(prefix ((ex: <http://example/>)) ( (prefix ((x: <http://EXAMPLE/>)) ex:abc) ))", r);
    }

    @Test
    public void testForm_01() {
        Item item = SSE.parse((String)"(prefix ((ex: <http://example/>)))");
        Assert.assertNull((Object)item);
    }

    @Test
    public void testForm_02() {
        Item item = SSE.parse((String)"(base <http://example/>)");
        Assert.assertNull((Object)item);
    }

    @Test
    public void testTypedLit_r1() {
        Node node = NodeFactory.createLiteral((String)"3", (RDFDatatype)XSDDatatype.XSDinteger);
        this.testItem("'3'^^xsd:integer", Item.createNode((Node)node));
    }

    @Test
    public void testBasePrefix_01() {
        Item r = SSE.parse((String)"<http://example/abc>", null);
        this.testItem("(base <http://example/> (prefix ((x: <>)) x:abc) )", r);
    }

    private void testItem(String str, Item result) {
        Item item = SSE.parse((String)str);
        Assert.assertEquals((Object)result, (Object)item);
    }

    static {
        pmap.setNsPrefix("xsd", XSD.getURI());
        pmap.setNsPrefix("ex", "http://example/");
    }
}

