/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.modify;

import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.sparql.modify.UpdateCompare;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;
import org.junit.Assert;
import org.junit.Test;

public class TestUpdateCompare {
    @Test
    public void updateCompare01() {
        this.test("INSERT DATA {}");
    }

    @Test
    public void updateCompare02() {
        this.test("INSERT DATA {<s> <p> <o>}");
    }

    @Test
    public void updateCompare03() {
        this.test("INSERT DATA {<s> <p> _:a}", "INSERT DATA {<s> <p> _:b}");
    }

    @Test
    public void updateCompare04() {
        this.test("INSERT DATA {<s> <p> _:a ; <p> 123 }", "INSERT DATA {<s> <p> _:b . <s> <p> 123 }");
    }

    @Test
    public void updateCompare05() {
        this.test("INSERT DATA {<s> <p> _:a ; <p> 123 }", "INSERT DATA {<s> <p> 123 . <s> <p> _:b .  }", false);
    }

    @Test
    public void updateCompare06() {
        this.test("DELETE DATA {}", "INSERT DATA {}", false);
    }

    @Test
    public void updateCompare07() {
        this.test("DELETE DATA {<s> <p> <o>}", "DELETE DATA {<s> <p> <o>}");
    }

    @Test
    public void updateCompare08() {
        this.test("DELETE {} INSERT {} WHERE {}");
    }

    @Test
    public void updateCompare09() {
        this.test("DELETE {<s> <p> ?v} INSERT {<s> <t> _:a } WHERE { <s> <p> _:a }");
    }

    @Test
    public void updateCompare10() {
        this.test("PREFIX : <http://example/> INSERT DATA { :s :p :o }");
    }

    @Test
    public void updateCompare11() {
        this.test("PREFIX : <http://example/> INSERT DATA { :s :p :o }", "PREFIX ex: <http://example/> INSERT DATA { ex:s ex:p ex:o }", false);
    }

    @Test
    public void updateCompare20() {
        String u1 = StrUtils.strjoinNL((String[])new String[]{"PREFIX : <http://example/>", "WITH :g1 INSERT { :s :p :o } WHERE {}"});
        this.test(u1);
    }

    @Test
    public void updateCompare21() {
        String u1 = "PREFIX : <http://example/> WITH :AAA INSERT { } WHERE {}";
        String u2 = "PREFIX : <http://example/> WITH :ZZZ INSERT { } WHERE {}";
        this.test(u1, u2, false);
    }

    @Test
    public void updateCompare22() {
        String u1 = "PREFIX : <http://example/> DELETE { } USING :G WHERE {}";
        this.test(u1);
    }

    @Test
    public void updateCompare23() {
        String u1 = "PREFIX : <http://example/> DELETE { } USING :G WHERE {}";
        String u2 = "PREFIX : <http://example/> DELETE { } USING :X WHERE {}";
        this.test(u1, u2, false);
    }

    @Test
    public void updateCompare24() {
        String u1 = "PREFIX : <http://example/> DELETE { } USING NAMED :G WHERE {}";
        this.test(u1);
    }

    @Test
    public void updateCompare25() {
        String u1 = "PREFIX : <http://example/> DELETE { } USING NAMED :G WHERE {}";
        String u2 = "PREFIX : <http://example/> DELETE { } USING :G WHERE {}";
        this.test(u1, u2, false);
    }

    private void test(String updateString) {
        this.test(updateString, updateString, true);
    }

    private void test(String updateString1, String updateString2) {
        this.test(updateString1, updateString2, true);
    }

    private void test(String updateString1, String updateString2, boolean isomorphic) {
        UpdateRequest update1 = UpdateFactory.create((String)updateString1);
        UpdateRequest update2 = UpdateFactory.create((String)updateString2);
        this.test(update1, update2, isomorphic);
    }

    private void test(UpdateRequest update1, UpdateRequest update2, boolean isomorphic) {
        boolean b = UpdateCompare.isomorphic((UpdateRequest)update1, (UpdateRequest)update2);
        Assert.assertEquals((String)update1.toString(), (Object)b, (Object)isomorphic);
    }
}

