/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.lib;

import java.math.BigDecimal;
import org.apache.jena.atlas.json.JsonBoolean;
import org.apache.jena.atlas.json.JsonNull;
import org.apache.jena.atlas.json.JsonNumber;
import org.apache.jena.atlas.json.JsonString;
import org.apache.jena.atlas.json.JsonValue;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.lib.RDFTerm2Json;
import org.apache.jena.sparql.sse.SSE;
import org.junit.Assert;
import org.junit.Test;

public class TestRDFTerm2Json {
    @Test
    public void n2j_1() {
        this.test("'abc'", (JsonValue)new JsonString("abc"));
    }

    @Test
    public void n2j_2() {
        this.test("<http://jena.apache.org/>", (JsonValue)new JsonString("http://jena.apache.org/"));
    }

    @Test
    public void n2j_3() {
        this.test("123", (JsonValue)JsonNumber.value((long)123L));
    }

    @Test
    public void n2j_4() {
        this.test("123.0", (JsonValue)JsonNumber.value((BigDecimal)new BigDecimal("123.0")));
    }

    @Test
    public void n2j_5() {
        this.test("123e0", (JsonValue)JsonNumber.value((double)123.0));
    }

    @Test
    public void n2j_6() {
        this.test("'123e0'^^xsd:float", (JsonValue)JsonNumber.value((double)123.0));
    }

    @Test
    public void n2j_7() {
        this.test("true", (JsonValue)new JsonBoolean(true));
    }

    @Test
    public void n2j_8() {
        this.test("'text'@en", (JsonValue)new JsonString("text"));
    }

    @Test
    public void n2j_9() {
        Assert.assertEquals((Object)JsonNull.instance, (Object)RDFTerm2Json.fromNode(null));
    }

    private void test(String nodeStr, JsonValue expected) {
        Node n = SSE.parseNode((String)nodeStr);
        JsonValue jv = RDFTerm2Json.fromNode((Node)n);
        Assert.assertEquals((Object)expected, (Object)jv);
    }
}

