/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.join;

import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.engine.join.AbstractTestJoin;
import org.apache.jena.sparql.engine.join.JoinKey;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.sse.SSE;
import org.junit.Test;

public abstract class AbstractTestLeftJoin
extends AbstractTestJoin {
    @Override
    protected void executeTest(JoinKey joinKey, Table left, Table right, ExprList conditions, Table expectedResults) {
        this.executeTestJoin("LJ", joinKey, left, right, conditions, expectedResults);
    }

    @Test
    public void leftjoin_basic_1() {
        this.testJoin("a", AbstractTestLeftJoin.table0(), AbstractTestLeftJoin.table0(), AbstractTestLeftJoin.table0());
    }

    @Test
    public void leftjoin_basic_2() {
        this.testJoin("a", AbstractTestLeftJoin.table1(), AbstractTestLeftJoin.table0(), AbstractTestLeftJoin.table1());
    }

    @Test
    public void leftjoin_basic_3() {
        this.testJoin("a", AbstractTestLeftJoin.tableD1(), AbstractTestLeftJoin.table1(), AbstractTestLeftJoin.tableD1());
    }

    @Test
    public void leftjoin_basic_4() {
        this.testJoin("z", AbstractTestLeftJoin.tableD1(), AbstractTestLeftJoin.table1(), AbstractTestLeftJoin.tableD1());
    }

    @Test
    public void leftjoin_01() {
        this.testJoin("a", AbstractTestLeftJoin.tableL1(), AbstractTestLeftJoin.tableL2(), AbstractTestLeftJoin.table1LJ2());
    }

    @Test
    public void leftjoin_02() {
        this.testJoin("a", AbstractTestLeftJoin.tableL4(), AbstractTestLeftJoin.tableL5(), AbstractTestLeftJoin.table4LJ5());
    }

    @Test
    public void leftjoin_03() {
        this.testJoin("z", AbstractTestLeftJoin.tableL1(), AbstractTestLeftJoin.tableL2(), AbstractTestLeftJoin.table1LJ2());
    }

    @Test
    public void leftjoin_04() {
        this.testJoin("z", AbstractTestLeftJoin.tableL4(), AbstractTestLeftJoin.tableL5(), AbstractTestLeftJoin.table4LJ5());
    }

    @Test
    public void leftjoin_J01() {
        this.testJoin("a", AbstractTestLeftJoin.tableD1(), AbstractTestLeftJoin.table1(), AbstractTestLeftJoin.tableD1());
    }

    @Test
    public void leftjoin_J01a() {
        this.testJoin("z", AbstractTestLeftJoin.tableD1(), AbstractTestLeftJoin.table1(), AbstractTestLeftJoin.tableD1());
    }

    @Test
    public void leftjoin_J02() {
        this.testJoin("a", AbstractTestLeftJoin.tableD1(), AbstractTestLeftJoin.table0(), AbstractTestLeftJoin.tableD1());
    }

    @Test
    public void leftjoin_J03() {
        this.testJoin("a", AbstractTestLeftJoin.tableD1(), AbstractTestLeftJoin.tableD2(), AbstractTestLeftJoin.tableD3());
    }

    @Test
    public void leftjoin_J04() {
        this.testJoin("a", AbstractTestLeftJoin.tableD2(), AbstractTestLeftJoin.table1(), AbstractTestLeftJoin.tableD2());
    }

    @Test
    public void leftjoin_J05() {
        this.testJoin("a", AbstractTestLeftJoin.table1(), AbstractTestLeftJoin.tableD2(), AbstractTestLeftJoin.tableD2());
    }

    @Test
    public void leftjoin_J06() {
        this.testJoin("z", AbstractTestLeftJoin.table1(), AbstractTestLeftJoin.tableD2(), AbstractTestLeftJoin.tableD2());
    }

    @Test
    public void leftjoin_J07() {
        this.testJoin("z", AbstractTestLeftJoin.tableD2(), AbstractTestLeftJoin.table1(), AbstractTestLeftJoin.tableD2());
    }

    @Test
    public void leftjoin_J08() {
        this.testJoin("a", AbstractTestLeftJoin.tableD4(), AbstractTestLeftJoin.tableD5(), AbstractTestLeftJoin.tableD4x5_LJ());
    }

    @Test
    public void leftjoin_J09() {
        this.testJoin("a", AbstractTestLeftJoin.tableD5(), AbstractTestLeftJoin.tableD4(), AbstractTestLeftJoin.tableD5x4_LJ());
    }

    @Test
    public void leftjoin_J10() {
        this.testJoin("a", AbstractTestLeftJoin.tableD4(), AbstractTestLeftJoin.tableD6(), AbstractTestLeftJoin.tableD4x6());
    }

    @Test
    public void leftjoin_J11() {
        this.testJoin("a", AbstractTestLeftJoin.tableD6(), AbstractTestLeftJoin.tableD4(), AbstractTestLeftJoin.tableD4x6());
    }

    @Test
    public void leftjoin_J12() {
        this.testJoin("z", AbstractTestLeftJoin.tableD1(), AbstractTestLeftJoin.tableD2(), AbstractTestLeftJoin.tableD3());
    }

    @Test
    public void leftjoin_J13() {
        this.testJoin("z", AbstractTestLeftJoin.tableD2(), AbstractTestLeftJoin.tableD1(), AbstractTestLeftJoin.tableD3_LJ());
    }

    @Test
    public void leftjoin_14() {
        this.testJoin(null, AbstractTestLeftJoin.tableD1(), AbstractTestLeftJoin.tableD2(), AbstractTestLeftJoin.tableD3());
    }

    @Test
    public void leftjoin_disjoint_01() {
        this.testJoin("a", AbstractTestLeftJoin.tableD2(), AbstractTestLeftJoin.tableD8(), AbstractTestLeftJoin.tableD8x2());
    }

    @Test
    public void leftjoin_disjoint_02() {
        this.testJoin("z", AbstractTestLeftJoin.tableD2(), AbstractTestLeftJoin.tableD8(), AbstractTestLeftJoin.tableD8x2());
    }

    @Test
    public void leftjoin_condition_01() {
        Table tableD1c = AbstractTestLeftJoin.parseTableInt("(table", "   (row (?a 1) (?b 3))", ")");
        this.testJoin("a", AbstractTestLeftJoin.table1(), AbstractTestLeftJoin.tableD1(), "((= ?b 3))", tableD1c);
    }

    @Test
    public void leftjoin_condition_02() {
        Table tableD3_LJc = AbstractTestLeftJoin.parseTableInt("(table", "   (row (?d 8) (?a 0))", "   (row (?a 1) (?c 9) (?b 2))", "   (row (?a 1) (?c 9) (?b 2))", ")");
        this.testJoin("a", AbstractTestLeftJoin.tableD2(), AbstractTestLeftJoin.tableD1(), "((= ?a 1) (= ?b 2))", tableD3_LJc);
    }

    @Test
    public void leftjoin_condition_03() {
        ExprList exprs = SSE.parseExprList((String)"((= ?b 99))");
        this.testJoin("a", AbstractTestLeftJoin.table1(), AbstractTestLeftJoin.tableD1(), "((= ?b 99))", AbstractTestLeftJoin.table1());
    }
}

