/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.junit.AssertExtra;
import org.apache.jena.atlas.lib.StreamOps;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.shared.AddDeniedException;
import org.apache.jena.shared.DeleteDeniedException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphBaseFind;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.graph.NodeConst;
import org.apache.jena.sparql.sse.SSE;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractDatasetGraphFind {
    static Node s = SSE.parseNode((String)":s");
    static Node p = SSE.parseNode((String)":p");
    static Node o = SSE.parseNode((String)":o");
    static Node g1 = SSE.parseNode((String)":g1");
    static Quad q1 = Quad.create((Node)Quad.defaultGraphIRI, (Node)s, (Node)p, (Node)o);
    static Quad q2 = Quad.create((Node)Quad.defaultGraphIRI, (Node)s, (Node)p, (Node)NodeConst.nodeZero);
    static Quad q3 = SSE.parseQuad((String)"(:g1 :s :p :o)");
    static Quad q4 = SSE.parseQuad((String)"(:g1 :s :p 1)");
    static Quad q5 = SSE.parseQuad((String)"(:g2 :s :p :o)");
    static Quad q6 = SSE.parseQuad((String)"(:g2 :s :p 1)");
    static Quad q7 = SSE.parseQuad((String)"(:g2 :s :p 2)");
    static Quad q8 = SSE.parseQuad((String)"(:g3 :s :p :o)");
    static Quad q9 = SSE.parseQuad((String)"(:g3 :s :p 1)");
    static Quad q10 = SSE.parseQuad((String)"(:g3 :s :p 2)");
    static List<Quad> data = Arrays.asList(q1, q2, q3, q4, q5, q6, q7, q8, q9, q10);
    private DatasetGraph dsg;

    static void add(DatasetGraph data, Collection<Quad> quads) {
        for (Quad q : quads) {
            data.add(q);
        }
    }

    protected DatasetGraph create(Collection<Quad> data) {
        DatasetGraph dsg = this.create();
        AbstractDatasetGraphFind.add(dsg, data);
        return dsg;
    }

    protected abstract DatasetGraph create();

    protected DatasetGraphBaseFind createFind(DatasetGraph dsg) {
        try {
            return (DatasetGraphBaseFind)dsg;
        }
        catch (ClassCastException ex) {
            Assert.fail((String)("Not a DatasetGraphBaseFind: " + dsg.getClass().getSimpleName()));
            return null;
        }
    }

    @Before
    public void setup() {
        this.dsg = this.create(data);
    }

    @Test
    public void find_quad_01() {
        List x = Iter.toList((Iterator)this.dsg.find());
        Assert.assertEquals((long)10L, (long)x.size());
        Assert.assertTrue((boolean)x.contains(q1));
        Assert.assertTrue((boolean)x.contains(q5));
    }

    @Test
    public void find_quad_02() {
        List x = Iter.toList((Iterator)this.dsg.find(null, s, p, o));
        Assert.assertEquals((long)4L, (long)x.size());
        Assert.assertFalse((boolean)x.contains(q2));
        Assert.assertFalse((boolean)x.contains(q4));
        Assert.assertTrue((boolean)x.contains(q5));
    }

    @Test
    public void find_ng_01() {
        List x = Iter.toList((Iterator)this.dsg.findNG(null, null, null, null));
        Assert.assertEquals((long)8L, (long)x.size());
        Assert.assertTrue((boolean)x.contains(q4));
        Assert.assertTrue((boolean)x.contains(q10));
        Assert.assertFalse((boolean)x.contains(q1));
    }

    @Test
    public void find_ng_02() {
        List x = Iter.toList((Iterator)this.dsg.findNG(null, s, p, o));
        Assert.assertEquals((long)3L, (long)x.size());
        Assert.assertFalse((boolean)x.contains(q4));
        Assert.assertFalse((boolean)x.contains(q1));
        Assert.assertTrue((boolean)x.contains(q3));
        Assert.assertTrue((boolean)x.contains(q5));
        Assert.assertTrue((boolean)x.contains(q8));
    }

    @Test
    public void find_specific_01() {
        List x = Iter.toList((Iterator)this.dsg.find(g1, null, null, null));
        Assert.assertEquals((long)2L, (long)x.size());
        Assert.assertTrue((boolean)x.contains(q4));
        Assert.assertTrue((boolean)x.contains(q3));
    }

    @Test
    public void find_specific_02() {
        List x = Iter.toList((Iterator)this.dsg.find(g1, null, null, NodeConst.nodeOne));
        Assert.assertEquals((long)1L, (long)x.size());
        Assert.assertTrue((boolean)x.contains(q4));
    }

    @Test
    public void find_dft_01() {
        List x = Iter.toList((Iterator)this.dsg.find(Quad.defaultGraphIRI, null, null, null));
        Assert.assertEquals((long)2L, (long)x.size());
        Assert.assertTrue((boolean)x.contains(q1));
        Assert.assertTrue((boolean)x.contains(q2));
    }

    @Test
    public void find_dft_02() {
        List x = Iter.toList((Iterator)this.dsg.find(Quad.defaultGraphIRI, null, null, NodeConst.nodeOne));
        Assert.assertEquals((long)0L, (long)x.size());
    }

    @Test
    public void find_dft_03() {
        List x = Iter.toList((Iterator)this.dsg.find(Quad.defaultGraphIRI, null, null, NodeConst.nodeZero));
        Assert.assertEquals((long)1L, (long)x.size());
        Assert.assertTrue((boolean)x.contains(q2));
    }

    @Test
    public void find_union_01() {
        List x = Iter.toList((Iterator)this.dsg.find(Quad.unionGraph, null, null, null));
        Assert.assertEquals((long)3L, (long)x.size());
        x.stream().allMatch(q -> q.getGraph().equals((Object)Quad.unionGraph));
        List z = x.stream().map(Quad::asTriple).collect(Collectors.toList());
        Assert.assertTrue((boolean)z.contains(q4.asTriple()));
        Assert.assertTrue((boolean)z.contains(q5.asTriple()));
        Quad qx = Quad.create((Node)Quad.unionGraph, (Triple)q4.asTriple());
        Assert.assertTrue((boolean)x.contains(qx));
        Quad qz = Quad.create((Node)Quad.unionGraph, (Triple)q2.asTriple());
        Assert.assertFalse((boolean)x.contains(qz));
    }

    @Test
    public void find_union_02() {
        DatasetGraphBaseFind dsgx = (DatasetGraphBaseFind)this.dsg;
        Assert.assertNotNull((Object)dsgx.getUnionGraph());
        List x = Iter.toList((Iterator)dsgx.getUnionGraph().find(null, null, null));
        Assert.assertEquals((long)3L, (long)x.size());
        Assert.assertTrue((boolean)x.contains(q4.asTriple()));
        Assert.assertTrue((boolean)x.contains(q5.asTriple()));
        Assert.assertTrue((boolean)x.contains(q10.asTriple()));
    }

    @Test
    public void find_union_03() {
        DatasetGraphBaseFind dsgx = (DatasetGraphBaseFind)this.dsg;
        Assert.assertNotNull((Object)dsgx.getUnionGraph());
        Set x1 = Iter.toSet((Iterator)dsgx.getUnionGraph().find(null, null, null));
        Set x2 = Iter.iter((Iterator)this.dsg.find(Quad.unionGraph, null, null, null)).map(Quad::asTriple).toSet();
        Assert.assertEquals((Object)x1, (Object)x2);
    }

    @Test(expected=AddDeniedException.class)
    public void find_union_04() {
        DatasetGraphBaseFind dsgx = (DatasetGraphBaseFind)this.dsg;
        dsgx.getUnionGraph().add(q4.asTriple());
    }

    @Test(expected=DeleteDeniedException.class)
    public void find_union_05() {
        DatasetGraphBaseFind dsgx = (DatasetGraphBaseFind)this.dsg;
        dsgx.getUnionGraph().delete(q4.asTriple());
    }

    @Test
    public void find_dsgFind_union_02() {
        Assume.assumeTrue((String)"Not a DatasetGraphBaseFind", (boolean)(this.dsg instanceof DatasetGraphBaseFind));
        DatasetGraphBaseFind dsgx = (DatasetGraphBaseFind)this.dsg;
        List x = Iter.toList((Iterator)dsgx.findInUnionGraph(null, null, null));
        Assert.assertEquals((long)3L, (long)x.size());
        Assert.assertTrue((boolean)x.contains(q4.asTriple()));
        Assert.assertTrue((boolean)x.contains(q5.asTriple()));
        Assert.assertTrue((boolean)x.contains(q10.asTriple()));
    }

    @Test
    public void find_dsgFind_union_03() {
        Assume.assumeTrue((String)"Not a DatasetGraphBaseFind", (boolean)(this.dsg instanceof DatasetGraphBaseFind));
        DatasetGraphBaseFind dsgx = (DatasetGraphBaseFind)this.dsg;
        List x1 = Iter.toList((Iterator)dsgx.findInUnionGraph(null, null, null));
        List<Triple> x2 = AbstractDatasetGraphFind.quadsToDistinctTriples(this.dsg.find(Quad.unionGraph, null, null, null));
        AssertExtra.assertEqualsUnordered((List)x1, x2);
        Assert.assertEquals((long)3L, (long)x2.size());
    }

    @Test
    public void find_dsgFind_union_04() {
        Assume.assumeTrue((String)"Not a DatasetGraphBaseFind", (boolean)(this.dsg instanceof DatasetGraphBaseFind));
        DatasetGraphBaseFind dsgx = (DatasetGraphBaseFind)this.dsg;
        List x = Iter.toList((Iterator)dsgx.findInUnionGraph(null, null, o));
        Assert.assertEquals((long)1L, (long)x.size());
        Assert.assertTrue((boolean)x.contains(q3.asTriple()));
    }

    @Test
    public void find_dsgFind_union_05() {
        Assume.assumeTrue((String)"Not a DatasetGraphBaseFind", (boolean)(this.dsg instanceof DatasetGraphBaseFind));
        DatasetGraphBaseFind dsgx = (DatasetGraphBaseFind)this.dsg;
        List x1 = Iter.toList((Iterator)dsgx.findInUnionGraph(null, null, o));
        List<Triple> x2 = AbstractDatasetGraphFind.quadsToDistinctTriples(this.dsg.find(Quad.unionGraph, null, null, o));
        AssertExtra.assertEqualsUnordered((List)x1, x2);
        Assert.assertEquals((long)1L, (long)x2.size());
    }

    @Test
    public void stream_dsg_01() {
        List x = StreamOps.toList((Stream)this.dsg.stream());
        Assert.assertEquals((long)10L, (long)x.size());
        Assert.assertTrue((boolean)x.contains(q1));
        Assert.assertTrue((boolean)x.contains(q5));
    }

    @Test
    public void stream_dsg_02() {
        List x = StreamOps.toList((Stream)this.dsg.stream(null, s, p, o));
        Assert.assertEquals((long)4L, (long)x.size());
        Assert.assertFalse((boolean)x.contains(q2));
        Assert.assertFalse((boolean)x.contains(q4));
        Assert.assertTrue((boolean)x.contains(q5));
    }

    static List<Triple> quadsToDistinctTriples(Iterator<Quad> iter) {
        return Iter.asStream(iter).map(Quad::asTriple).distinct().collect(Collectors.toList());
    }

    static void print(List<Quad> x) {
        ((Stream)x.stream().sequential()).forEach(System.out::println);
    }
}

