/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.writer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.jena.atlas.json.JSON;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.sse.SSE;
import org.junit.Assert;
import org.junit.Test;

public class TestRDFJSON {
    @Test
    public void rdfjson_00() {
        this.test("(base <http://example/> (graph))");
    }

    @Test
    public void rdfjson_01() {
        this.test("(base <http://example/> (graph (<s> <p> 1)))");
    }

    @Test
    public void rdfjson_02() {
        this.test("(base <http://example/> (graph (<s1> <p> 1)(<s> <p> 2)))");
    }

    @Test
    public void rdfjson_03() {
        this.test("(base <http://example/> (graph (<s> <p> 1)(<s> <q> 2)))");
    }

    @Test
    public void rdfjson_04() {
        this.test("(base <http://example/> (graph (<s> <p> 1)(<s> <p> 2)))");
    }

    @Test
    public void rdfjson_05() {
        this.test("(base <http://example/> (graph ", "(<s> <p> 1)", "(<s> <p> 2)", "(<s1> <p> 2)", "))");
    }

    @Test
    public void rdfjson_06() {
        this.test("(base <http://example/> (graph ", "(_:a <p> 1)", "(_:a <p> 2)", "(_:b <p> 3)", "))");
    }

    @Test
    public void rdfjson_07() {
        this.test("(base <http://example/> (graph ", "(<s> <p> _:abc)", "(<s> <p> 2)", "(<s1> <p> _:abc)", "))");
    }

    @Test
    public void rdfjson_08() {
        this.test("(base <http://example/> (graph ", "(<s> <p> <http://example.org/abc>)", "(<s> <p> 2)", "(<s1> <p> <http://example.org/abc>)", "))");
    }

    @Test
    public void rdfjson_09() {
        this.test("(base <http://example/> (graph ", "(_:s <p> <http://example.org/abc>)", "(<http://example.org/abc> <p> _:s)", "))");
    }

    @Test
    public void rdfjson_literals() {
        this.test("(base <http://example/>", " (graph ", "   (<s> <p> 'abc')", "   (<s> <p> 'abc'@en)", "   (<s> <p> 'abc'^^xsd:string)", "   (<s> <p> '1'^^xsd:integer)", "   (<s> <p> '1e+100'^^xsd:double)", "   (<s> <p> '1.05'^^xsd:decimal)", "))");
    }

    @Test
    public void rdfjson_escapes() {
        Graph g = GraphFactory.createGraphMem();
        Node s = NodeFactory.createBlankNode();
        Node p = NodeFactory.createURI((String)"http://host");
        g.add(new Triple(s, p, NodeFactory.createLiteral((String)"quote \" character")));
        g.add(new Triple(s, p, NodeFactory.createLiteral((String)"new \n\r lines")));
        g.add(new Triple(s, p, NodeFactory.createLiteral((String)"tab \t character")));
        this.test(g);
    }

    private void test(String ... strings) {
        String str = StrUtils.strjoinNL((String[])strings);
        Graph g = SSE.parseGraph((String)str);
        this.test(g);
    }

    private void test(Graph g) {
        ByteArrayOutputStream bout = this.serializeAsJSON(g);
        this.parseAsJSON(bout);
        Graph g2 = this.parseAsRDFJSON(bout);
        Assert.assertTrue((boolean)g.isIsomorphicWith(g2));
    }

    private ByteArrayOutputStream serializeAsJSON(Graph graph) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        RDFDataMgr.write((OutputStream)bout, (Graph)graph, (Lang)Lang.RDFJSON);
        return bout;
    }

    private Graph parseAsRDFJSON(ByteArrayOutputStream bout) {
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        Graph graph = GraphFactory.createGraphMem();
        RDFDataMgr.read((Graph)graph, (InputStream)bin, (Lang)Lang.RDFJSON);
        return graph;
    }

    private JsonObject parseAsJSON(ByteArrayOutputStream bout) {
        return JSON.parse((InputStream)new ByteArrayInputStream(bout.toByteArray()));
    }
}

