/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import org.apache.jena.rdf.model.impl.RDFReaderFImpl;
import org.apache.jena.riot.IO_Jena;
import org.apache.jena.riot.adapters.RDFReaderRIOT;
import org.apache.jena.shared.NoReaderForLangException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestIO_JenaReaders {
    @BeforeClass
    public static void beforeClass() {
    }

    @AfterClass
    public static void afterClass() {
        IO_Jena.wireIntoJena();
    }

    @Test
    public void wireIntoJena() {
        IO_Jena.wireIntoJena();
        RDFReaderFImpl readerF = new RDFReaderFImpl();
        Assert.assertEquals(RDFReaderRIOT.class, readerF.getReader().getClass());
        Assert.assertEquals(RDFReaderRIOT.class, readerF.getReader("RDF/XML").getClass());
        Assert.assertEquals(RDFReaderRIOT.class, readerF.getReader("RDF/XML-ABBREV").getClass());
        Assert.assertEquals(RDFReaderRIOT.class, readerF.getReader("N-TRIPLES").getClass());
        Assert.assertEquals(RDFReaderRIOT.class, readerF.getReader("N-Triples").getClass());
        Assert.assertEquals(RDFReaderRIOT.class, readerF.getReader("N-TRIPLE").getClass());
        Assert.assertEquals(RDFReaderRIOT.class, readerF.getReader("N3").getClass());
        Assert.assertEquals(RDFReaderRIOT.class, readerF.getReader("TURTLE").getClass());
        Assert.assertEquals(RDFReaderRIOT.class, readerF.getReader("Turtle").getClass());
        Assert.assertEquals(RDFReaderRIOT.class, readerF.getReader("TTL").getClass());
        Assert.assertEquals(RDFReaderRIOT.class, readerF.getReader("JSON-LD").getClass());
        Assert.assertEquals(RDFReaderRIOT.class, readerF.getReader("JSONLD").getClass());
        Assert.assertEquals(RDFReaderRIOT.class, readerF.getReader("RDF/JSON").getClass());
    }

    @Test
    public void resetJena() {
        IO_Jena.wireIntoJena();
        IO_Jena.resetJena();
        RDFReaderFImpl readerF = new RDFReaderFImpl();
        Assert.assertNotEquals(RDFReaderRIOT.class, readerF.getReader().getClass());
        Assert.assertNotEquals(RDFReaderRIOT.class, readerF.getReader("RDF/XML").getClass());
        Assert.assertNotEquals(RDFReaderRIOT.class, readerF.getReader("RDF/XML-ABBREV").getClass());
        Assert.assertNotEquals(RDFReaderRIOT.class, readerF.getReader("N-TRIPLES").getClass());
        Assert.assertNotEquals(RDFReaderRIOT.class, readerF.getReader("N-Triples").getClass());
        Assert.assertNotEquals(RDFReaderRIOT.class, readerF.getReader("N-TRIPLE").getClass());
        Assert.assertNotEquals(RDFReaderRIOT.class, readerF.getReader("N3").getClass());
        Assert.assertNotEquals(RDFReaderRIOT.class, readerF.getReader("TURTLE").getClass());
        Assert.assertNotEquals(RDFReaderRIOT.class, readerF.getReader("Turtle").getClass());
        Assert.assertNotEquals(RDFReaderRIOT.class, readerF.getReader("TTL").getClass());
        try {
            readerF.getReader("NT");
            Assert.fail((String)"Exception expected");
        }
        catch (NoReaderForLangException noReaderForLangException) {
            // empty catch block
        }
        try {
            readerF.getReader("JSON_LD");
            Assert.fail((String)"Exception expected");
        }
        catch (NoReaderForLangException noReaderForLangException) {
            // empty catch block
        }
        try {
            readerF.getReader("RDF/JSON");
            Assert.fail((String)"Exception expected");
        }
        catch (NoReaderForLangException noReaderForLangException) {
            // empty catch block
        }
        IO_Jena.wireIntoJena();
    }
}

