/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfs;

import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdfs.RDFSFactory;
import org.apache.jena.rdfs.engine.ConstRDFS;
import org.apache.jena.riot.other.G;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.sse.SSE;
import org.junit.Assert;
import org.junit.Test;

public class TestMiscRDFS {
    private static Graph vocabSC = SSE.parseGraph((String)"(graph (:S rdfs:subClassOf :T))");
    private static Graph dataSC = SSE.parseGraph((String)"(graph (:x rdf:type :S))");
    private static Graph vocabDomain = SSE.parseGraph((String)"(graph (:p rdfs:domain :D) )");
    private static Graph dataDomain = SSE.parseGraph((String)"(graph (:x :p 123))");
    private static Graph vocabDomainSC = SSE.parseGraph((String)"(graph (:p rdfs:domain :R) (:R rdfs:subClassOf :T) )");
    private static Graph dataDomainSC = SSE.parseGraph((String)"(graph (:x :p 123))");
    private static Graph vocabRangeSC = SSE.parseGraph((String)"(graph (:q rdfs:domain :R) (:p rdfs:domain :R0) (:R rdfs:subClassOf :T) )");
    private static Graph dataRangeSC = SSE.parseGraph((String)"(graph (:x :p 123) (:y :q :z))");

    private static Node node(String str) {
        return SSE.parseNode((String)str);
    }

    private static void exactlyOne(Graph graph, Node s, Node p, Node o) {
        G.getOne((Graph)graph, (Node)s, (Node)p, (Node)o);
    }

    private static long count(Graph graph, Node s, Node p, Node o) {
        return Iter.count((Iterator)graph.find(s, p, o));
    }

    private static long count(DatasetGraph dsg, Node g, Node s, Node p, Node o) {
        return Iter.count((Iterator)dsg.find(g, s, p, o));
    }

    @Test
    public void emptyDataEmptyVocab() {
        Graph vocab = GraphFactory.createDefaultGraph();
        Graph data = GraphFactory.createDefaultGraph();
        Graph rdfs = RDFSFactory.graphRDFS((Graph)data, (Graph)vocab);
        Assert.assertTrue((boolean)rdfs.isEmpty());
        Assert.assertFalse((boolean)rdfs.contains(ConstRDFS.ANY, ConstRDFS.ANY, ConstRDFS.ANY));
        Assert.assertEquals((long)0L, (long)TestMiscRDFS.count(rdfs, ConstRDFS.ANY, ConstRDFS.ANY, ConstRDFS.ANY));
    }

    @Test
    public void domainOnly() {
        Graph rdfs = RDFSFactory.graphRDFS((Graph)dataDomain, (Graph)vocabDomain);
        TestMiscRDFS.exactlyOne(rdfs, null, ConstRDFS.rdfType, TestMiscRDFS.node(":D"));
        Assert.assertEquals((long)2L, (long)TestMiscRDFS.count(rdfs, ConstRDFS.ANY, ConstRDFS.ANY, ConstRDFS.ANY));
    }

    @Test
    public void domainST() {
        Graph rdfs = RDFSFactory.graphRDFS((Graph)dataDomainSC, (Graph)vocabDomainSC);
        TestMiscRDFS.exactlyOne(rdfs, null, ConstRDFS.rdfType, TestMiscRDFS.node(":T"));
        TestMiscRDFS.exactlyOne(rdfs, null, ConstRDFS.rdfType, TestMiscRDFS.node(":R"));
        TestMiscRDFS.exactlyOne(rdfs, null, null, TestMiscRDFS.node(":R"));
        Assert.assertEquals((long)3L, (long)TestMiscRDFS.count(rdfs, ConstRDFS.ANY, ConstRDFS.ANY, ConstRDFS.ANY));
    }

    @Test
    public void rangeST() {
        Graph rdfs = RDFSFactory.graphRDFS((Graph)dataRangeSC, (Graph)vocabRangeSC);
        TestMiscRDFS.exactlyOne(rdfs, null, ConstRDFS.rdfType, TestMiscRDFS.node(":T"));
        TestMiscRDFS.exactlyOne(rdfs, null, ConstRDFS.rdfType, TestMiscRDFS.node(":R"));
        TestMiscRDFS.exactlyOne(rdfs, null, null, TestMiscRDFS.node(":R"));
        Assert.assertEquals((long)5L, (long)TestMiscRDFS.count(rdfs, ConstRDFS.ANY, ConstRDFS.ANY, ConstRDFS.ANY));
    }

    @Test
    public void dataset() {
        Graph vocab = SSE.parseGraph((String)"(graph (:S rdfs:subClassOf :T))");
        DatasetGraph dsg0 = DatasetGraphFactory.createTxnMem();
        DatasetGraph dsg = RDFSFactory.datasetRDFS((DatasetGraph)dsg0, (Graph)vocab);
        dsg.add(Quad.defaultGraphIRI, TestMiscRDFS.node(":s0"), ConstRDFS.rdfType, TestMiscRDFS.node(":S"));
        Assert.assertEquals((long)0L, (long)TestMiscRDFS.count(dsg, Quad.unionGraph, ConstRDFS.ANY, ConstRDFS.rdfType, ConstRDFS.ANY));
        Assert.assertEquals((long)2L, (long)TestMiscRDFS.count(dsg, ConstRDFS.ANY, ConstRDFS.ANY, ConstRDFS.rdfType, ConstRDFS.ANY));
        dsg.add(TestMiscRDFS.node(":g1"), TestMiscRDFS.node(":s1"), ConstRDFS.rdfType, TestMiscRDFS.node(":S"));
        dsg.add(TestMiscRDFS.node(":g2"), TestMiscRDFS.node(":s2"), ConstRDFS.rdfType, TestMiscRDFS.node(":S"));
        Assert.assertEquals((long)4L, (long)TestMiscRDFS.count(dsg, Quad.unionGraph, ConstRDFS.ANY, ConstRDFS.rdfType, ConstRDFS.ANY));
        Assert.assertEquals((long)2L, (long)TestMiscRDFS.count(dsg, Quad.defaultGraphIRI, ConstRDFS.ANY, ConstRDFS.rdfType, ConstRDFS.ANY));
        Assert.assertEquals((long)6L, (long)TestMiscRDFS.count(dsg, ConstRDFS.ANY, ConstRDFS.ANY, ConstRDFS.rdfType, ConstRDFS.ANY));
        Assert.assertEquals((long)3L, (long)TestMiscRDFS.count(dsg0, ConstRDFS.ANY, ConstRDFS.ANY, ConstRDFS.rdfType, ConstRDFS.ANY));
        Assert.assertEquals((long)1L, (long)Iter.count((Iterator)dsg.findNG(TestMiscRDFS.node(":g1"), null, null, TestMiscRDFS.node(":T"))));
        Assert.assertEquals((long)2L, (long)Iter.count((Iterator)dsg.findNG(TestMiscRDFS.node(":g1"), TestMiscRDFS.node(":s1"), ConstRDFS.rdfType, ConstRDFS.ANY)));
        Graph g = dsg.getDefaultGraph();
        TestMiscRDFS.exactlyOne(g, ConstRDFS.ANY, ConstRDFS.ANY, TestMiscRDFS.node(":S"));
        TestMiscRDFS.exactlyOne(g, ConstRDFS.ANY, ConstRDFS.ANY, TestMiscRDFS.node(":T"));
    }
}

