/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfs;

import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdfs.RDFSFactory;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.sse.SSE;
import org.junit.Assert;
import org.junit.Test;

public class TestInfSPARQL {
    private static String PREFIXES = "PREFIX : <http://example/>\n";
    private static Graph vocabDomainSC = SSE.parseGraph((String)"(graph (:p rdfs:domain :R) (:R rdfs:subClassOf :T) )");
    private static Graph dataDomainSC = SSE.parseGraph((String)"(graph (:x :p 123))");
    private static Graph vocabRangeSC = SSE.parseGraph((String)"(graph (:q rdfs:domain :R) (:p rdfs:domain :R0) (:R rdfs:subClassOf :T) )");

    private static Node node(String str) {
        return SSE.parseNode((String)str);
    }

    private static Quad quad(String str) {
        return SSE.parseQuad((String)str);
    }

    @Test
    public void sparql1() {
        Graph vocab = vocabDomainSC;
        DatasetGraph dsg0 = DatasetGraphFactory.createTxnMem();
        DatasetGraph dsg = RDFSFactory.datasetRDFS((DatasetGraph)dsg0, (Graph)vocab);
        dsg.executeWrite(() -> dsg.add(TestInfSPARQL.quad("(_ :x :p 123)")));
        String qs = PREFIXES + "SELECT (count(*) AS ?C) { ?s ?p ?o }";
        Query query = QueryFactory.create((String)qs);
        try (QueryExecution qExec = QueryExecutionFactory.create((Query)query, (DatasetGraph)dsg);){
            ResultSet rs = qExec.execSelect();
            int c = rs.next().getLiteral("C").getInt();
            Assert.assertEquals((long)3L, (long)c);
        }
    }

    @Test
    public void sparql2() {
        int c;
        ResultSet rs;
        Graph vocab = vocabDomainSC;
        DatasetGraph dsg0 = DatasetGraphFactory.createTxnMem();
        DatasetGraph dsg = RDFSFactory.datasetRDFS((DatasetGraph)dsg0, (Graph)vocab);
        dsg.executeWrite(() -> dsg.add(TestInfSPARQL.quad("(:g :x :p 123)")));
        String qs1 = PREFIXES + "SELECT (count(*) AS ?C) { ?s ?p ?o }";
        Query query1 = QueryFactory.create((String)qs1);
        try (QueryExecution qExec = QueryExecutionFactory.create((Query)query1, (DatasetGraph)dsg);){
            rs = qExec.execSelect();
            c = rs.next().getLiteral("C").getInt();
            Assert.assertEquals((long)0L, (long)c);
        }
        String qs2 = PREFIXES + "SELECT (count(*) AS ?C) { GRAPH ?g { ?s ?p ?o } }";
        Query query2 = QueryFactory.create((String)qs2);
        qExec = QueryExecutionFactory.create((Query)query2, (DatasetGraph)dsg);
        try {
            rs = qExec.execSelect();
            c = rs.next().getLiteral("C").getInt();
            Assert.assertEquals((long)3L, (long)c);
        }
        finally {
            if (qExec != null) {
                qExec.close();
            }
        }
    }

    @Test
    public void sparql3() {
        Graph vocab = vocabDomainSC;
        DatasetGraph dsg0 = DatasetGraphFactory.createTxnMem();
        DatasetGraph dsg = RDFSFactory.datasetRDFS((DatasetGraph)dsg0, (Graph)vocab);
        dsg.executeWrite(() -> {
            dsg.add(TestInfSPARQL.quad("(:g1 :x :p 123)"));
            dsg.add(TestInfSPARQL.quad("(:g2 :x :p 123)"));
            dsg.add(TestInfSPARQL.quad("(:g2 :x :q 'noDR')"));
        });
        String qs2 = PREFIXES + "SELECT (count(*) AS ?C) { GRAPH <" + Quad.unionGraph.getURI() + "> { ?s ?p ?o } }";
        Query query2 = QueryFactory.create((String)qs2);
        try (QueryExecution qExec = QueryExecutionFactory.create((Query)query2, (DatasetGraph)dsg);){
            ResultSet rs = qExec.execSelect();
            int c = rs.next().getLiteral("C").getInt();
            Assert.assertEquals((long)4L, (long)c);
        }
    }
}

