/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfs;

import java.io.PrintStream;
import java.util.List;
import org.apache.jena.atlas.lib.ListUtils;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdfs.LibTestRDFS;
import org.apache.jena.rdfs.engine.ConstRDFS;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public abstract class AbstractTestRDFS {
    private static PrintStream out = System.err;

    @Test
    public void test_rdfs_01() {
        this.test(LibTestRDFS.node("a"), ConstRDFS.rdfType, null);
    }

    @Test
    public void test_rdfs_02() {
        this.test(LibTestRDFS.node("a"), ConstRDFS.rdfType, LibTestRDFS.node("T2"));
    }

    @Test
    public void test_rdfs_03() {
        this.test(null, ConstRDFS.rdfType, LibTestRDFS.node("T2"));
    }

    @Test
    public void test_rdfs_04() {
        this.test(null, null, LibTestRDFS.node("T2"));
    }

    @Test
    public void test_rdfs_05() {
        this.test(null, ConstRDFS.rdfType, LibTestRDFS.node("T"));
    }

    @Test
    public void test_rdfs_05a() {
        this.test(null, null, LibTestRDFS.node("T"));
    }

    @Test
    public void test_rdfs_06() {
        this.test(LibTestRDFS.node("c"), ConstRDFS.rdfType, null);
    }

    @Test
    public void test_rdfs_06a() {
        this.test(LibTestRDFS.node("c"), null, null);
    }

    @Test
    public void test_rdfs_07() {
        this.test(null, ConstRDFS.rdfType, null);
    }

    @Test
    public void test_rdfs_08() {
        this.test(null, LibTestRDFS.node("q"), null);
    }

    @Test
    public void test_rdfs_08a() {
        this.test(null, LibTestRDFS.node("p"), null);
    }

    @Test
    public void test_rdfs_08b() {
        this.test(null, LibTestRDFS.node("pp"), null);
    }

    @Test
    public void test_rdfs_08c() {
        this.test(null, LibTestRDFS.node("ppp"), null);
    }

    @Test
    public void test_rdfs_08d() {
        this.test(null, LibTestRDFS.node("pTop"), null);
    }

    @Test
    public void test_rdfs_09() {
        this.test(LibTestRDFS.node("z"), null, null);
    }

    @Test
    public void test_rdfs_10() {
        this.test(LibTestRDFS.node("z"), ConstRDFS.rdfType, null);
    }

    @Test
    public void test_rdfs_12a() {
        this.test(null, ConstRDFS.rdfType, LibTestRDFS.node("P"));
    }

    @Test
    public void test_rdfs_12b() {
        this.test(null, ConstRDFS.rdfType, LibTestRDFS.node("P1"));
    }

    @Test
    public void test_rdfs_12c() {
        this.test(null, ConstRDFS.rdfType, LibTestRDFS.node("P2"));
    }

    @Test
    public void test_rdfs_12d() {
        this.test(null, null, LibTestRDFS.node("P"));
    }

    @Test
    public void test_rdfs_12e() {
        this.test(null, null, LibTestRDFS.node("P1"));
    }

    @Test
    public void test_rdfs_12f() {
        this.test(null, null, LibTestRDFS.node("P2"));
    }

    @Test
    public void test_rdfs_13a() {
        this.test(null, ConstRDFS.rdfType, LibTestRDFS.node("Q"));
    }

    @Test
    public void test_rdfs_13b() {
        this.test(null, ConstRDFS.rdfType, LibTestRDFS.node("Q1"));
    }

    @Test
    public void test_rdfs_13c() {
        this.test(null, ConstRDFS.rdfType, LibTestRDFS.node("Q2"));
    }

    @Test
    public void test_rdfs_13d() {
        this.test(null, null, LibTestRDFS.node("Q"));
    }

    @Test
    public void test_rdfs_13e() {
        this.test(null, null, LibTestRDFS.node("Q1"));
    }

    @Test
    public void test_rdfs_13f() {
        this.test(null, null, LibTestRDFS.node("Q2"));
    }

    @Test
    public void test_rdfs_14a() {
        this.test(null, ConstRDFS.rdfType, LibTestRDFS.node("T"));
    }

    @Test
    public void test_rdfs_14b() {
        this.test(null, ConstRDFS.rdfType, LibTestRDFS.node("T1"));
    }

    @Test
    public void test_rdfs_14c() {
        this.test(null, ConstRDFS.rdfType, LibTestRDFS.node("S2"));
    }

    @Test
    public void test_rdfs_14d() {
        this.test(null, null, LibTestRDFS.node("T"));
    }

    @Test
    public void test_rdfs_14e() {
        this.test(null, null, LibTestRDFS.node("T1"));
    }

    @Test
    public void test_rdfs_14f() {
        this.test(null, null, LibTestRDFS.node("S2"));
    }

    @Test
    public void test_rdfs_15a() {
        this.test(null, ConstRDFS.rdfType, LibTestRDFS.node("U"));
    }

    @Test
    public void test_rdfs_15b() {
        this.test(null, null, LibTestRDFS.node("U"));
    }

    @Test
    public void test_rdfs_16a() {
        this.test(null, null, LibTestRDFS.node("Other"));
    }

    @Test
    public void test_rdfs_16b() {
        this.test(null, ConstRDFS.rdfType, LibTestRDFS.node("Other"));
    }

    @Test
    public void test_rdfs_17a() {
        this.test(null, null, LibTestRDFS.node("X"));
    }

    @Test
    public void test_rdfs_17b() {
        this.test(null, ConstRDFS.rdfType, LibTestRDFS.node("X"));
    }

    @Test
    public void test_rdfs_20() {
        this.test(null, LibTestRDFS.node("p"), null);
    }

    @Test
    public void test_rdfs_21() {
        this.test(null, LibTestRDFS.node("pp"), null);
    }

    @Test
    public void test_rdfs_22() {
        this.test(null, LibTestRDFS.node("ppp"), null);
    }

    @Test
    public void test_rdfs_23() {
        this.test(null, LibTestRDFS.node("pTop"), null);
    }

    @Test
    public void test_rdfs_30() {
        this.test(LibTestRDFS.node("e"), null, null);
    }

    @Test
    public void test_rdfs_31() {
        this.test(LibTestRDFS.node("e"), LibTestRDFS.node("r"), null);
    }

    @Test
    public void test_rdfs_40() {
        this.test(null, ConstRDFS.rdfsSubClassOf, null);
    }

    @Test
    public void test_rdfs_40a() {
        this.test(LibTestRDFS.node("T3"), ConstRDFS.rdfsSubClassOf, null);
    }

    @Test
    public void test_rdfs_40b() {
        this.test(null, ConstRDFS.rdfsSubClassOf, LibTestRDFS.node("T3"));
    }

    @Test
    public void test_rdfs_40c() {
        this.test(LibTestRDFS.node("T3"), ConstRDFS.rdfsSubClassOf, LibTestRDFS.node("T3"));
    }

    @Test
    public void test_rdfs_40c2() {
        this.test(LibTestRDFS.node("T3"), ConstRDFS.rdfsSubClassOf, LibTestRDFS.node("U"));
    }

    @Test
    public void test_rdfs_41a() {
        this.test(LibTestRDFS.node("T"), ConstRDFS.rdfsSubClassOf, null);
    }

    @Test
    public void test_rdfs_41b() {
        this.test(null, ConstRDFS.rdfsSubClassOf, LibTestRDFS.node("T"));
    }

    @Test
    public void test_rdfs_41c() {
        this.test(LibTestRDFS.node("T"), ConstRDFS.rdfsSubClassOf, LibTestRDFS.node("T"));
    }

    @Test
    public void test_rdfs_41c2() {
        this.test(LibTestRDFS.node("T"), ConstRDFS.rdfsSubClassOf, LibTestRDFS.node("U"));
    }

    @Test
    public void test_rdfs_42a() {
        this.test(LibTestRDFS.node("U"), ConstRDFS.rdfsSubClassOf, null);
    }

    @Test
    public void test_rdfs_42b() {
        this.test(null, ConstRDFS.rdfsSubClassOf, LibTestRDFS.node("U"));
    }

    @Test
    public void test_rdfs_42c() {
        this.test(LibTestRDFS.node("U"), ConstRDFS.rdfsSubClassOf, LibTestRDFS.node("U"));
    }

    @Test
    public void test_rdfs_40d() {
        this.test(LibTestRDFS.node("NO"), ConstRDFS.rdfsSubClassOf, null);
    }

    @Test
    public void test_rdfs_40e() {
        this.test(null, ConstRDFS.rdfsSubClassOf, LibTestRDFS.node("NO"));
    }

    @Test
    public void test_rdfs_40f() {
        this.test(LibTestRDFS.node("NO"), ConstRDFS.rdfsSubClassOf, LibTestRDFS.node("NO"));
    }

    @Test
    public void test_rdfs_40g() {
        this.test(LibTestRDFS.node("NO"), ConstRDFS.rdfsSubClassOf, LibTestRDFS.node("U"));
    }

    @Test
    public void test_rdfs_40h() {
        this.test(LibTestRDFS.node("T3"), ConstRDFS.rdfsSubClassOf, LibTestRDFS.node("T"));
    }

    @Test
    public void test_rdfs_50() {
        this.test(null, ConstRDFS.rdfsSubPropertyOf, null);
    }

    @Test
    public void test_rdfs_50a() {
        this.test(LibTestRDFS.node("p"), ConstRDFS.rdfsSubPropertyOf, null);
    }

    @Test
    public void test_rdfs_50b() {
        this.test(null, ConstRDFS.rdfsSubPropertyOf, LibTestRDFS.node("p"));
    }

    @Test
    public void test_rdfs_50c() {
        this.test(LibTestRDFS.node("p"), ConstRDFS.rdfsSubPropertyOf, LibTestRDFS.node("p"));
    }

    @Test
    public void test_rdfs_99_all() {
        this.test(null, null, null);
    }

    protected void test(Node s, Node p, Node o) {
        List<Triple> actual;
        boolean b;
        List<Triple> expected = LibTestRDFS.findInGraph(this.getReferenceGraph(), s, p, o);
        if (this.removeVocabFromReferenceResults()) {
            expected = LibTestRDFS.removeRDFS(expected);
        }
        if (!(b = ListUtils.equalsUnordered(expected, actual = LibTestRDFS.findInGraph(this.getTestGraph(), s, p, o)))) {
            out.println("Fail: find(" + s + ", " + p + ", " + o + ")");
            LibTestRDFS.printDiff(out, expected, actual);
        }
        Assert.assertTrue((String)this.getTestLabel(), (boolean)b);
    }

    protected abstract boolean removeVocabFromReferenceResults();

    protected abstract Graph getReferenceGraph();

    protected abstract Graph getTestGraph();

    protected abstract String getReferenceLabel();

    protected abstract String getTestLabel();
}

