/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.AnonId;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.sparql.engine.JsonIterator;
import org.junit.Assert;
import org.junit.Test;

public class TestResultSetFormatter {
    @Test
    public void testIterator() throws IOException {
        Model model = ModelFactory.createDefaultModel();
        Resource r = model.createResource(AnonId.create((String)"first"));
        Property p = model.getProperty("");
        Literal node = ResourceFactory.createTypedLiteral((String)"123", (RDFDatatype)XSDDatatype.XSDdecimal);
        model.add(r, p, (RDFNode)node);
        r = model.createResource(AnonId.create((String)"second"));
        p = model.getProperty("");
        node = ResourceFactory.createTypedLiteral((String)"abc", (RDFDatatype)XSDDatatype.XSDstring);
        model.add(r, p, (RDFNode)node);
        r = model.createResource(AnonId.create((String)"third"));
        p = model.getProperty("");
        node = ResourceFactory.createLangLiteral((String)"def", (String)"en");
        model.add(r, p, (RDFNode)node);
        r = model.createResource(AnonId.create((String)"fourth"));
        p = model.getProperty("");
        node = ResourceFactory.createTypedLiteral((String)"true", (RDFDatatype)XSDDatatype.XSDboolean);
        model.add(r, p, (RDFNode)node);
        Query query = QueryFactory.create((String)"JSON { \"s\": ?s , \"p\": ?p , \"o\" : ?o } WHERE { ?s ?p ?o }", (Syntax)Syntax.syntaxARQ);
        try (QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)model);){
            JsonIterator execJsonItems = (JsonIterator)qexec.execJsonItems();
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                ResultSetFormatter.output((OutputStream)baos, (Iterator)execJsonItems);
                String output = baos.toString(Charset.forName("UTF-8"));
                Assert.assertTrue((boolean)output.contains("\"_:first\""));
                Assert.assertTrue((boolean)output.contains("\"_:second\""));
                Assert.assertTrue((boolean)output.contains("\"_:third\""));
                Assert.assertTrue((boolean)output.contains("\"_:fourth\""));
                Assert.assertFalse((boolean)output.contains("\"true\""));
                Assert.assertTrue((boolean)output.contains("true"));
                Assert.assertTrue((boolean)output.contains("123"));
                Assert.assertFalse((boolean)output.contains("\"123\""));
                Assert.assertTrue((boolean)output.contains("\"abc\""));
            }
        }
    }
}

