/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.junit.manifest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.apache.jena.arq.junit.manifest.ExTestSetup;
import org.apache.jena.arq.junit.manifest.ManifestEntry;
import org.apache.jena.atlas.lib.IRILib;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.TestManifest;
import org.apache.jena.vocabulary.TestManifestX;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Manifest {
    private static Logger log = LoggerFactory.getLogger(Manifest.class);
    private Model manifest;
    private String manifestName;
    private String filename;
    private List<String> includedFiles = new ArrayList<String>();
    private List<ManifestEntry> entries = new ArrayList<ManifestEntry>();
    private Resource manifestRes = null;

    public static Manifest parse(String manifestFile) {
        Manifest manifest = new Manifest(manifestFile);
        return manifest;
    }

    public static void walk(Manifest manifest, Consumer<Manifest> actionManifest, Consumer<ManifestEntry> actionEntry) {
        actionManifest.accept(manifest);
        Iterator<String> sub = manifest.includedManifests();
        while (sub.hasNext()) {
            String mf = sub.next();
            Manifest manifestSub = Manifest.parse(mf);
            Manifest.walk(manifestSub, actionManifest, actionEntry);
        }
        for (ManifestEntry entry : manifest.entries()) {
            actionEntry.accept(entry);
        }
    }

    private Manifest(String fn) {
        this.filename = IRILib.filenameToIRI((String)fn);
        this.manifest = RDFDataMgr.loadModel((String)this.filename);
        this.parseManifest();
        this.parseIncludes();
        this.parseEntries();
    }

    public String getName() {
        return this.manifestName;
    }

    public String getFileName() {
        return this.filename;
    }

    public Iterator<String> includedManifests() {
        return this.includedFiles.iterator();
    }

    public List<ManifestEntry> entries() {
        return this.entries;
    }

    private void parseManifest() {
        StmtIterator manifestStmts = this.manifest.listStatements(null, RDF.type, (RDFNode)TestManifest.Manifest);
        if (!manifestStmts.hasNext()) {
            log.warn("No manifest in manifest file: " + this.filename);
            return;
        }
        Statement manifestItemStmt = manifestStmts.nextStatement();
        if (manifestStmts.hasNext()) {
            log.warn("Multiple manifests in manifest file: " + this.filename);
            return;
        }
        this.manifestRes = manifestItemStmt.getSubject();
        this.manifestName = Manifest.getLiteral(this.manifestRes, RDFS.label);
        if (this.manifestName == null) {
            this.manifestName = Manifest.getLiteral(this.manifestRes, RDFS.comment);
        }
        if (this.manifestName == null) {
            this.manifestName = Manifest.getLiteral(this.manifestRes, TestManifest.name);
        }
        manifestStmts.close();
    }

    private void parseEntries() {
        StmtIterator manifestStmts = this.manifest.listStatements(null, RDF.type, (RDFNode)TestManifest.Manifest);
        while (manifestStmts.hasNext()) {
            Statement manifestItemStmt = manifestStmts.nextStatement();
            Resource manifestRes = manifestItemStmt.getSubject();
            StmtIterator listIter = manifestRes.listProperties(TestManifest.entries);
            while (listIter.hasNext()) {
                Resource listItem = listIter.nextStatement().getResource();
                while (!listItem.equals((Object)RDF.nil)) {
                    Resource entry = listItem.getRequiredProperty(RDF.first).getResource();
                    String testName = Manifest.getLiteral(entry, TestManifest.name);
                    Resource action = Manifest.getResource(entry, TestManifest.action);
                    Resource result = Manifest.getResource(entry, TestManifest.result);
                    Resource testType = Manifest.getResource(entry, RDF.type);
                    ManifestEntry manifestEntry = new ManifestEntry(this, entry, testName, testType, action, result);
                    this.entries.add(manifestEntry);
                    listItem = listItem.getRequiredProperty(RDF.rest).getResource();
                }
            }
            listIter.close();
        }
        manifestStmts.close();
    }

    private void parseIncludes() {
        this.parseIncludes(TestManifest.include);
        this.parseIncludes(TestManifestX.include);
    }

    private void parseIncludes(Property property) {
        StmtIterator includeStmts = this.manifest.listStatements(null, property, (RDFNode)null);
        while (includeStmts.hasNext()) {
            Statement s = includeStmts.nextStatement();
            if (!(s.getObject() instanceof Resource)) {
                log.warn("Include: not a Resource" + s);
                continue;
            }
            Resource r = s.getResource();
            this.parseOneIncludesList(r);
        }
        includeStmts.close();
    }

    private void parseOneIncludesList(Resource r) {
        if (r == null) {
            return;
        }
        if (r.equals((Object)RDF.nil)) {
            return;
        }
        if (!r.isAnon()) {
            String uri = r.getURI();
            if (this.includedFiles.contains(uri)) {
                return;
            }
            this.includedFiles.add(r.getURI());
            return;
        }
        Resource listItem = r;
        while (!listItem.equals((Object)RDF.nil)) {
            r = listItem.getRequiredProperty(RDF.first).getResource();
            this.parseOneIncludesList(r);
            listItem = listItem.getRequiredProperty(RDF.rest).getResource();
        }
    }

    private static Resource getResource(Resource r, Property p) {
        if (r == null) {
            return null;
        }
        if (!r.hasProperty(p)) {
            return null;
        }
        RDFNode n = r.getProperty(p).getObject();
        if (n instanceof Resource) {
            return (Resource)n;
        }
        throw new ExTestSetup("Manifest problem (not a Resource): " + n + " => " + p);
    }

    private static Collection<Resource> listResources(Resource r, Property p) {
        if (r == null) {
            return null;
        }
        ArrayList<Resource> x = new ArrayList<Resource>();
        StmtIterator sIter = r.listProperties(p);
        while (sIter.hasNext()) {
            RDFNode n = ((Statement)sIter.next()).getObject();
            if (!(n instanceof Resource)) {
                throw new ExTestSetup("Manifest problem (not a Resource): " + n + " => " + p);
            }
            x.add((Resource)n);
        }
        return x;
    }

    private static String getLiteral(Resource r, Property p) {
        if (r == null) {
            return null;
        }
        if (!r.hasProperty(p)) {
            return null;
        }
        RDFNode n = r.getProperty(p).getObject();
        if (n instanceof Literal) {
            return ((Literal)n).getLexicalForm();
        }
        throw new ExTestSetup("Manifest problem (not a Literal): " + n + " => " + p);
    }

    private static String getLiteralOrURI(Resource r, Property p) {
        Resource r2;
        if (r == null) {
            return null;
        }
        if (!r.hasProperty(p)) {
            return null;
        }
        RDFNode n = r.getProperty(p).getObject();
        if (n instanceof Literal) {
            return ((Literal)n).getLexicalForm();
        }
        if (n instanceof Resource && !(r2 = (Resource)n).isAnon()) {
            return r2.getURI();
        }
        throw new ExTestSetup("Manifest problem: " + n + " => " + p);
    }

    private static String safeName(String s) {
        s = s.replace('(', '[');
        s = s.replace(')', ']');
        return s;
    }

    public String toString() {
        return "manifest[" + this.filename + "]";
    }
}

