/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.ext.com.google.common.collect.ArrayListMultimap;
import org.apache.jena.ext.com.google.common.collect.Multimap;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.other.G;
import org.apache.jena.shacl.engine.Parameter;
import org.apache.jena.shacl.engine.constraint.ConstraintComponentSPARQL;
import org.apache.jena.shacl.engine.constraint.SparqlComponent;
import org.apache.jena.shacl.lib.ShLib;
import org.apache.jena.shacl.parser.Constraint;
import org.apache.jena.shacl.parser.Parameters;
import org.apache.jena.shacl.parser.ShaclParseException;
import org.apache.jena.shacl.parser.Shape;
import org.apache.jena.shacl.vocabulary.SHACL;

public class ConstraintComponents {
    Multimap<Node, SparqlComponent> paramPathToComponents = ArrayListMultimap.create();
    Set<Parameter> parameters = new HashSet<Parameter>();

    ConstraintComponents() {
    }

    boolean hasParameters() {
        return this.parameters.isEmpty();
    }

    public static ConstraintComponents parseSparqlConstraintComponents(Graph shapesGraph) {
        ConstraintComponents x = new ConstraintComponents();
        G.allNodesOfTypeRDFS((Graph)shapesGraph, (Node)SHACL.ConstraintComponent).forEach(sccNode -> {
            SparqlComponent c = ConstraintComponents.sparqlConstraintComponent(shapesGraph, sccNode);
            if (c != null) {
                for (Parameter p : c.getParams()) {
                    x.paramPathToComponents.put((Object)p.getParameterPath(), (Object)c);
                    x.parameters.add(p);
                }
            }
        });
        return x;
    }

    public static List<Constraint> processShape(Graph shapesGraph, ConstraintComponents components, Shape shape) {
        ArrayList<Constraint> constraints = new ArrayList<Constraint>();
        HashSet seen = new HashSet();
        for (Parameter param : components.parameters) {
            if (param.isOptional()) continue;
            Node paramPath = param.getParameterPath();
            boolean b = G.contains((Graph)shapesGraph, (Node)shape.getShapeNode(), (Node)paramPath, null);
            if (!b) continue;
            Node shNode = shape.getShapeNode();
            Collection sccs = components.paramPathToComponents.get((Object)paramPath);
            sccs.forEach(scc -> {
                List<Node> required = scc.getRequiredParameters();
                HashSet<Node> x = new HashSet<Node>(required);
                if (seen.contains(x)) {
                    return;
                }
                seen.add(x);
                if (Parameters.doesShapeHaveAllParameters(shapesGraph, shape.getShapeNode(), required)) {
                    Multimap<Parameter, Node> parameterValues = ConstraintComponents.constraintParameterValues(shapesGraph, shNode, scc);
                    if (parameterValues.keySet().size() > 1) {
                        HashMap parameterMap = new HashMap();
                        parameterValues.asMap().forEach((p, values) -> {
                            if (values.size() > 1) {
                                throw new ShaclParseException("Multiple values for parameter " + p + " in constraint with multiple parameters");
                            }
                        });
                    }
                    ConstraintComponentSPARQL constraintComponentSPARQL = new ConstraintComponentSPARQL((SparqlComponent)scc, parameterValues);
                    constraints.add(constraintComponentSPARQL);
                }
            });
        }
        return constraints;
    }

    private static Multimap<Parameter, Node> constraintParameterValues(Graph shapesGraph, Node shNode, SparqlComponent scc) {
        Node nodeValidatorNode = G.getZeroOrOneSP((Graph)shapesGraph, (Node)shNode, (Node)SHACL.nodeValidator);
        Node propertyValidatorNode = G.getZeroOrOneSP((Graph)shapesGraph, (Node)shNode, (Node)SHACL.propertyValidator);
        Node validatorNode = G.getZeroOrOneSP((Graph)shapesGraph, (Node)shNode, (Node)SHACL.validator);
        Node vNode = (Node)ObjectUtils.firstNonNull((Object[])new Node[]{nodeValidatorNode, propertyValidatorNode, validatorNode});
        Multimap<Parameter, Node> parameterValues = Parameters.parameterValues(shapesGraph, shNode, scc);
        return parameterValues;
    }

    private static SparqlComponent sparqlConstraintComponent(Graph shapesGraph, Node constraintComponentNode) {
        if (SHACL.JSConstraintComponent.equals((Object)constraintComponentNode)) {
            return null;
        }
        List<Parameter> params = Parameters.parseParameters(shapesGraph, constraintComponentNode);
        SparqlComponent x = ConstraintComponents.possibleValidator(shapesGraph, constraintComponentNode, SHACL.nodeValidator, params);
        if (x == null) {
            x = ConstraintComponents.possibleValidator(shapesGraph, constraintComponentNode, SHACL.propertyValidator, params);
        }
        if (x == null) {
            x = ConstraintComponents.possibleValidator(shapesGraph, constraintComponentNode, SHACL.validator, params);
        }
        return x;
    }

    private static SparqlComponent possibleValidator(Graph shapesGraph, Node constraintComponentNode, Node vProperty, List<Parameter> params) {
        List x = G.listSP((Graph)shapesGraph, (Node)constraintComponentNode, (Node)vProperty);
        if (x.isEmpty()) {
            return null;
        }
        for (Node valNode : x) {
            SparqlComponent cs = ConstraintComponents.possibleSparqlValidator(shapesGraph, valNode, params, constraintComponentNode);
            if (cs == null) continue;
            return cs;
        }
        return null;
    }

    private static SparqlComponent possibleSparqlValidator(Graph shapesGraph, Node valNode, List<Parameter> params, Node constraintComponentNode) {
        Node xJSFunctionName = G.getZeroOrOneSP((Graph)shapesGraph, (Node)valNode, (Node)SHACL.jsFunctionName);
        if (xJSFunctionName != null) {
            Log.warn(ConstraintComponents.class, (String)"Found javascript validator - ignored (JavaScript not currently supported)");
        }
        Node xSelect = G.getZeroOrOneSP((Graph)shapesGraph, (Node)valNode, (Node)SHACL.select);
        Node xAsk = G.getZeroOrOneSP((Graph)shapesGraph, (Node)valNode, (Node)SHACL.ask);
        if (xSelect == null && xAsk == null) {
            return null;
        }
        if (xSelect != null && xAsk != null) {
            throw new ShaclParseException("SparqlConstraintComponent: Multiple SPARQL queries: " + ShLib.displayStr(constraintComponentNode));
        }
        String prefixes = ShLib.prefixes(shapesGraph, valNode);
        Object queryString = ((Node)ObjectUtils.firstNonNull((Object[])new Node[]{xSelect, xAsk})).getLiteralLexicalForm().trim();
        String message = ConstraintComponents.asString(G.getZeroOrOneSP((Graph)shapesGraph, (Node)valNode, (Node)SHACL.message));
        if (!prefixes.isEmpty()) {
            queryString = prefixes + "\n" + (String)queryString;
        }
        boolean isSelect = xSelect != null;
        SparqlComponent cs = SparqlComponent.constraintComponent(constraintComponentNode, (String)queryString, params, message);
        if (cs.getQuery().isSelectType() != isSelect) {
            throw new ShaclParseException("Query type does not match property");
        }
        return cs;
    }

    private static String asString(Node x) {
        if (x == null) {
            return null;
        }
        if (!x.isLiteral()) {
            return null;
        }
        return x.getLiteralLexicalForm();
    }
}

