/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import org.apache.jena.atlas.lib.CollectionUtils;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.riot.other.G;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.shacl.ShaclException;
import org.apache.jena.shacl.engine.Target;
import org.apache.jena.shacl.engine.constraint.SparqlComponent;
import org.apache.jena.shacl.lib.ShLib;
import org.apache.jena.shacl.parser.TargetExtensions;
import org.apache.jena.shacl.sys.C;
import org.apache.jena.shacl.validation.EvalSparql;
import org.apache.jena.shacl.vocabulary.SHACL;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;

public class TargetOps {
    public static String strTargets(Collection<Target> targets, NodeFormatter nodeFmt) {
        if (targets.size() == 1) {
            return TargetOps.strTarget((Target)CollectionUtils.oneElt(targets), nodeFmt);
        }
        StringJoiner sj = new StringJoiner(", ", "(", ")");
        targets.forEach(t -> sj.add(TargetOps.strTarget(t, nodeFmt)));
        return sj.toString();
    }

    public static String strTarget(Target target, NodeFormatter nodeFmt) {
        if (nodeFmt == null) {
            nodeFmt = ShLib.nodeFmtAbbrev;
        }
        switch (target.getTargetType()) {
            case implicitClass: {
                return "T/Impl [" + ShLib.displayStr(target.getObject(), nodeFmt) + "]";
            }
            case targetClass: {
                return "T/Class [?x rdf:type " + ShLib.displayStr(target.getObject(), nodeFmt) + "]";
            }
            case targetNode: {
                return "T/Node [?x = " + ShLib.displayStr(target.getObject(), nodeFmt) + "]";
            }
            case targetObjectsOf: {
                return "T/Obj [_ " + ShLib.displayStr(target.getObject(), nodeFmt) + " ?x]";
            }
            case targetSubjectsOf: {
                return "T/Subj [?x " + ShLib.displayStr(target.getObject(), nodeFmt) + " _]";
            }
            case targetExtension: {
                return "T/Ext [" + ShLib.displayStr(target.getObject(), nodeFmt) + "]";
            }
        }
        return "** Unknown **";
    }

    public static Set<Node> shapesTargetClass(Graph shapesGraph) {
        return shapesGraph.find(Node.ANY, SHACL.targetClass, null).mapWith(Triple::getSubject).toSet();
    }

    public static Set<Node> shapesTargetNode(Graph shapesGraph) {
        return shapesGraph.find(Node.ANY, SHACL.targetNode, Node.ANY).mapWith(Triple::getSubject).toSet();
    }

    public static Set<Node> shapesTargetObjectsOf(Graph shapesGraph) {
        return shapesGraph.find(Node.ANY, SHACL.targetObjectsOf, Node.ANY).mapWith(Triple::getSubject).toSet();
    }

    public static Set<Node> shapesTargetSubjectsOf(Graph shapesGraph) {
        return shapesGraph.find(Node.ANY, SHACL.targetSubjectsOf, Node.ANY).mapWith(Triple::getSubject).toSet();
    }

    public static Set<Node> implicitClassTargets(Graph shapesGraph) {
        Set allClasses = G.allNodesOfTypeRDFS((Graph)shapesGraph, (Node)C.rdfsClass);
        if (allClasses.isEmpty()) {
            return Collections.emptySet();
        }
        Set nodeShapes = G.allNodesOfTypeRDFS((Graph)shapesGraph, (Node)SHACL.NodeShape);
        Set propertyShapes = G.allNodesOfTypeRDFS((Graph)shapesGraph, (Node)SHACL.PropertyShape);
        nodeShapes.retainAll(allClasses);
        propertyShapes.retainAll(allClasses);
        HashSet<Node> acc = new HashSet<Node>();
        acc.addAll(nodeShapes);
        acc.addAll(propertyShapes);
        return acc;
    }

    public static Set<Node> shapesTargetExtension(Graph shapesGraph) {
        HashSet x = new HashSet();
        return G.allPO((Graph)shapesGraph, (Node)SHACL.target, null);
    }

    private static Set<Node> shapesTargetSPARQL(Graph shapesGraph) {
        return G.find((Graph)shapesGraph, null, (Node)SHACL.target, null).filterKeep(t -> G.hasOneSP((Graph)shapesGraph, (Node)t.getObject(), (Node)SHACL.select)).mapWith(Triple::getSubject).toSet();
    }

    private static Set<Node> shapesSPARQLTargetType(Graph shapesGraph) {
        return G.find((Graph)shapesGraph, null, (Node)SHACL.target, null).filterKeep(t -> G.isOfType((Graph)shapesGraph, (Node)t.getObject(), (Node)SHACL.Target)).mapWith(Triple::getSubject).toSet();
    }

    public static Collection<Node> focusTargetClass(Graph data, Target target) {
        return G.allNodesOfTypeRDFS((Graph)data, (Node)target.getObject());
    }

    public static Collection<Node> focusImplicitClass(Graph data, Target target) {
        return TargetOps.focusTargetClass(data, target);
    }

    public static Collection<Node> focusTargetNode(Graph data, Target target) {
        return Collections.singletonList(target.getObject());
    }

    public static Collection<Node> focusSubjectsOf(Graph data, Target target) {
        return G.allPO((Graph)data, (Node)target.getObject(), null);
    }

    public static Collection<Node> focusObjectsOf(Graph data, Target target) {
        return G.allSP((Graph)data, null, (Node)target.getObject());
    }

    public static Collection<Node> focusTargetExt(Graph data, Target target) {
        Node targetArg;
        Graph shapesGraph = Objects.requireNonNull(target.getShapesGraph());
        if (G.hasOneSP((Graph)shapesGraph, (Node)(targetArg = target.getObject()), (Node)SHACL.select)) {
            Query query = ShLib.extractSPARQLQuery(shapesGraph, targetArg);
            if (!query.isSelectType()) {
                throw new ShaclException("Not a SELECT query");
            }
            DatasetGraph dsg = DatasetGraphFactory.wrap((Graph)data);
            QueryExecution qExec = QueryExecutionFactory.create((Query)query, (DatasetGraph)dsg);
            return EvalSparql.evalSparqlOneVar(qExec);
        }
        if (G.isOfType((Graph)shapesGraph, (Node)targetArg, (Node)SHACL.Target)) {
            Node type;
            List types = G.typesOfNodeAsList((Graph)shapesGraph, (Node)targetArg);
            if (types.size() == 1) {
                type = (Node)CollectionUtils.oneElt((Collection)types);
            } else {
                Set allClasses = G.subClasses((Graph)shapesGraph, (Node)SHACL.Target);
                Optional<Node> x = types.stream().filter(t -> allClasses.contains(t)).findFirst();
                type = x.orElseThrow();
            }
            try {
                SparqlComponent sparqlComponent = TargetExtensions.sparqlTargetType(shapesGraph, type);
                return EvalSparql.evalSparqlComponent(data, target.getObject(), sparqlComponent);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        throw new ShaclException("Unknown target extension");
    }
}

