/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdf.model;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.rdf.model.AnonId;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.ModelChangedListener;
import org.apache.jena.rdf.model.ModelCon;
import org.apache.jena.rdf.model.ModelGraphInterface;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.NsIterator;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.RDFReaderF;
import org.apache.jena.rdf.model.RDFReaderI;
import org.apache.jena.rdf.model.RDFWriterF;
import org.apache.jena.rdf.model.RDFWriterI;
import org.apache.jena.rdf.model.RSIterator;
import org.apache.jena.rdf.model.ReifiedStatement;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Selector;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.shared.Lock;
import org.apache.jena.shared.PrefixMapping;

public interface Model
extends ModelCon,
ModelGraphInterface,
RDFReaderF,
RDFWriterF,
PrefixMapping,
Lock {
    @Override
    @Deprecated
    public RDFReaderI getReader();

    @Override
    @Deprecated
    public RDFReaderI getReader(String var1);

    @Override
    @Deprecated
    public RDFWriterI getWriter();

    @Override
    @Deprecated
    public RDFWriterI getWriter(String var1);

    public long size();

    public boolean isEmpty();

    public ResIterator listSubjects();

    public NsIterator listNameSpaces();

    public Resource getResource(String var1);

    public Property getProperty(String var1, String var2);

    public Resource createResource();

    public Resource createResource(AnonId var1);

    public Resource createResource(String var1);

    public Resource createResource(Statement var1);

    public Property createProperty(String var1, String var2);

    public Literal createLiteral(String var1, String var2);

    @Deprecated
    public Literal createLiteral(String var1, boolean var2);

    public Literal createTypedLiteral(String var1, RDFDatatype var2);

    public Literal createTypedLiteral(Object var1, RDFDatatype var2);

    @Override
    public Literal createTypedLiteral(Object var1);

    public Statement createStatement(Resource var1, Property var2, RDFNode var3);

    public RDFList createList();

    public RDFList createList(Iterator<? extends RDFNode> var1);

    public RDFList createList(RDFNode ... var1);

    public Model add(Statement var1);

    public Model add(Statement[] var1);

    public Model remove(Statement[] var1);

    public Model add(List<Statement> var1);

    public Model remove(List<Statement> var1);

    public Model add(StmtIterator var1);

    public Model add(Model var1);

    public Model read(String var1);

    public Model read(InputStream var1, String var2);

    public Model read(InputStream var1, String var2, String var3);

    public Model read(Reader var1, String var2);

    public Model read(String var1, String var2);

    public Model read(Reader var1, String var2, String var3);

    public Model read(String var1, String var2, String var3);

    public Model write(Writer var1);

    public Model write(Writer var1, String var2);

    public Model write(Writer var1, String var2, String var3);

    public Model write(OutputStream var1);

    public Model write(OutputStream var1, String var2);

    public Model write(OutputStream var1, String var2, String var3);

    public Model remove(Statement var1);

    public Statement getRequiredProperty(Resource var1, Property var2);

    public Statement getRequiredProperty(Resource var1, Property var2, String var3);

    public Statement getProperty(Resource var1, Property var2);

    public Statement getProperty(Resource var1, Property var2, String var3);

    public ResIterator listSubjectsWithProperty(Property var1);

    public ResIterator listResourcesWithProperty(Property var1);

    public ResIterator listSubjectsWithProperty(Property var1, RDFNode var2);

    public ResIterator listResourcesWithProperty(Property var1, RDFNode var2);

    public NodeIterator listObjects();

    public NodeIterator listObjectsOfProperty(Property var1);

    public NodeIterator listObjectsOfProperty(Resource var1, Property var2);

    public boolean contains(Resource var1, Property var2);

    public boolean containsResource(RDFNode var1);

    public boolean contains(Resource var1, Property var2, RDFNode var3);

    public boolean contains(Statement var1);

    public boolean containsAny(StmtIterator var1);

    public boolean containsAll(StmtIterator var1);

    public boolean containsAny(Model var1);

    public boolean containsAll(Model var1);

    @Deprecated
    public boolean isReified(Statement var1);

    @Deprecated
    public Resource getAnyReifiedStatement(Statement var1);

    @Deprecated
    public void removeAllReifications(Statement var1);

    @Deprecated
    public void removeReification(ReifiedStatement var1);

    public StmtIterator listStatements();

    @Deprecated
    public StmtIterator listStatements(Selector var1);

    public StmtIterator listStatements(Resource var1, Property var2, RDFNode var3);

    @Deprecated
    public ReifiedStatement createReifiedStatement(Statement var1);

    @Deprecated
    public ReifiedStatement createReifiedStatement(String var1, Statement var2);

    @Deprecated
    public RSIterator listReifiedStatements();

    @Deprecated
    public RSIterator listReifiedStatements(Statement var1);

    @Deprecated
    public Model query(Selector var1);

    public Model union(Model var1);

    public Model intersection(Model var1);

    public Model difference(Model var1);

    public boolean equals(Object var1);

    public Model begin();

    public Model abort();

    public Model commit();

    public void executeInTxn(Runnable var1);

    public <T> T calculateInTxn(Supplier<T> var1);

    public boolean independent();

    public boolean supportsTransactions();

    public boolean supportsSetOperations();

    public boolean isIsomorphicWith(Model var1);

    public void close();

    public Lock getLock();

    public Model register(ModelChangedListener var1);

    public Model unregister(ModelChangedListener var1);

    public Model notifyEvent(Object var1);

    public Model removeAll();

    public Model removeAll(Resource var1, Property var2, RDFNode var3);

    public boolean isClosed();

    @Override
    public Model setNsPrefix(String var1, String var2);

    @Override
    public Model removeNsPrefix(String var1);

    @Override
    public Model clearNsPrefixMap();

    @Override
    public Model setNsPrefixes(PrefixMapping var1);

    @Override
    public Model setNsPrefixes(Map<String, String> var1);

    @Override
    public Model withDefaultMappings(PrefixMapping var1);
}

