/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.graph;

import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.GraphBase;
import org.apache.jena.mem.GraphMem;
import org.apache.jena.mem2.GraphMem2Fast;
import org.apache.jena.mem2.GraphMem2Legacy;
import org.apache.jena.mem2.GraphMem2Roaring;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NullIterator;

public class GraphMemFactory {
    private static boolean defaultSameTerm = false;
    private static final Graph emptyGraph;

    public static void setDftGraphSameTerm(boolean value) {
        defaultSameTerm = value;
    }

    public static boolean dftGraphSameTerm() {
        return defaultSameTerm;
    }

    private GraphMemFactory() {
    }

    public static Graph createDefaultGraph() {
        return GraphMemFactory.dftGraphSameTerm() ? GraphMemFactory.createDefaultGraphSameTerm() : GraphMemFactory.createDefaultGraphSameValue();
    }

    public static Graph createGraphMem() {
        return new GraphMem();
    }

    public static Graph createDefaultGraphSameValue() {
        return new GraphMem();
    }

    public static Graph createDefaultGraphSameTerm() {
        return GraphMemFactory.createGraphMem2();
    }

    public static Graph createGraphMem2Basic() {
        return new GraphMem2Legacy();
    }

    public static Graph createGraphMem2() {
        return new GraphMem2Fast();
    }

    public static Graph createGraphMem2Roaring() {
        return new GraphMem2Roaring();
    }

    public static Graph empty() {
        return emptyGraph;
    }

    static {
        String x = System.getProperty("jena:graphSameTerm");
        if (x != null && x.equalsIgnoreCase("true")) {
            defaultSameTerm = true;
        }
        emptyGraph = new GraphBase(){

            @Override
            protected ExtendedIterator<Triple> graphBaseFind(Triple triplePattern) {
                return NullIterator.instance();
            }
        };
    }
}

