/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.riot.RDFLanguages;

public class Lang {
    public static Lang RDFXML;
    public static Lang TURTLE;
    public static Lang TTL;
    public static Lang N3;
    public static Lang NTRIPLES;
    public static Lang NT;
    public static Lang JSONLD;
    public static Lang RDFJSON;
    public static Lang TRIG;
    public static Lang NQUADS;
    public static Lang NQ;
    public static Lang RDFTHRIFT;
    public static Lang SHACLC;
    public static Lang CSV;
    public static Lang TSV;
    public static Lang TRIX;
    public static Lang RDFNULL;
    private final String label;
    private final ContentType contentType;
    private final List<String> altLabels;
    private final List<String> altContentTypes;
    private final List<String> fileExtensions;

    protected Lang(String langlabel, String mainContentType, List<String> altLangLabels, List<String> otherContentTypes, List<String> fileExt) {
        if (langlabel == null) {
            throw new IllegalArgumentException("Null not allowed for language name");
        }
        this.label = langlabel = langlabel.intern();
        String mediaType = mainContentType;
        this.contentType = mediaType == null ? null : ContentType.create(mediaType);
        List<String> _altContentTypes = Lang.copy(otherContentTypes);
        if (!_altContentTypes.contains(mainContentType)) {
            _altContentTypes.add(mainContentType);
        }
        this.altContentTypes = Collections.unmodifiableList(_altContentTypes);
        List<String> _altLabels = Lang.copy(altLangLabels);
        if (!_altLabels.contains(this.label)) {
            _altLabels.add(this.label);
        }
        this.altLabels = Collections.unmodifiableList(_altLabels);
        List<String> _fileExtensions = Lang.copy(fileExt);
        this.fileExtensions = Collections.unmodifiableList(_fileExtensions);
    }

    static <T> List<T> copy(List<T> original) {
        ArrayList<T> x = new ArrayList<T>();
        x.addAll(original);
        return x;
    }

    public int hashCode() {
        return this.label.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof Lang)) {
            return false;
        }
        Lang otherLang = (Lang)other;
        return this.label == otherLang.label && this.contentType.equals(otherLang.contentType) && this.altContentTypes.equals(otherLang.altContentTypes) && this.fileExtensions.equals(otherLang.fileExtensions);
    }

    public String getName() {
        return this.label;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public String getHeaderString() {
        return this.contentType.toHeaderString();
    }

    public String getLabel() {
        return this.label;
    }

    public List<String> getAltNames() {
        return this.altLabels;
    }

    public List<String> getAltContentTypes() {
        return this.altContentTypes;
    }

    public List<String> getFileExtensions() {
        return this.fileExtensions;
    }

    public String toString() {
        return "Lang:" + this.label;
    }

    public String toLongString() {
        String x = "Lang:" + this.label + " " + this.getContentType();
        if (this.getAltNames().size() > 0) {
            x = x + " " + this.getAltNames();
        }
        if (this.getAltContentTypes().size() > 0) {
            x = x + " " + this.getAltContentTypes();
        }
        if (this.getFileExtensions().size() > 0) {
            x = x + " " + this.getFileExtensions();
        }
        return x;
    }

    static {
        RDFLanguages.init();
    }
}

