/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.compact.writer;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.CollectionUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.riot.out.NodeFormatterTTL;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.shacl.ShaclException;
import org.apache.jena.shacl.Shapes;
import org.apache.jena.shacl.compact.SHACLC;
import org.apache.jena.shacl.compact.writer.ShaclNotCompactException;
import org.apache.jena.shacl.compact.writer.ShapeOutputVisitor;
import org.apache.jena.shacl.engine.Target;
import org.apache.jena.shacl.engine.TargetType;
import org.apache.jena.shacl.parser.Constraint;
import org.apache.jena.shacl.parser.Shape;
import org.apache.jena.shared.PrefixMapping;

public class CompactWriter {
    public static void print(IndentedWriter out, Shapes shapes) {
        PrefixMapping graphPrefixMapping = shapes.getGraph().getPrefixMapping();
        PrefixMap pmapWithStd = SHACLC.withStandardPrefixes();
        graphPrefixMapping.getNsPrefixMap().forEach((p, u) -> pmapWithStd.add(p, u));
        NodeFormatterTTL nodeFmt = new NodeFormatterTTL(null, pmapWithStd);
        boolean someOutput = false;
        Node baseURI = shapes.getBase();
        if (baseURI != null && baseURI.isURI()) {
            if (someOutput) {
                out.println();
            }
            RiotLib.writeBase((IndentedWriter)out, (String)baseURI.getURI(), (boolean)true);
            someOutput = true;
        }
        if (!graphPrefixMapping.hasNoMappings()) {
            PrefixMap pm = PrefixMapFactory.create((PrefixMapping)graphPrefixMapping);
            if (someOutput) {
                out.println();
            }
            RiotLib.writePrefixes((IndentedWriter)out, (PrefixMap)pm, (boolean)true);
            someOutput = true;
        }
        if (shapes.getImports() != null && !shapes.getImports().isEmpty()) {
            if (someOutput) {
                out.println();
            }
            shapes.getImports().forEach(arg_0 -> CompactWriter.lambda$print$1(out, (NodeFormatter)nodeFmt, arg_0));
        }
        PrefixMapping prefixMappingWithStd = SHACLC.withStandardPrefixes(graphPrefixMapping);
        ShapeOutputVisitor visitor = new ShapeOutputVisitor(prefixMappingWithStd, (NodeFormatter)nodeFmt, out);
        shapes.iteratorAll().forEachRemaining(arg_0 -> CompactWriter.lambda$print$2(out, prefixMappingWithStd, (NodeFormatter)nodeFmt, visitor, arg_0));
        out.flush();
    }

    private static void writeOneShapeCompact(IndentedWriter out, PrefixMapping prefixMappingWithStd, NodeFormatter nodeFmt, ShapeOutputVisitor visitor, Shape sh) {
        if (sh.getShapeNode().isURI()) {
            CompactWriter.output(out, nodeFmt, visitor, sh);
        }
    }

    private static void writeOneShapeCompactOrSkip(IndentedWriter out, PrefixMapping prefixMappingWithStd, NodeFormatter nodeFmt, ShapeOutputVisitor visitor, Shape sh) {
        try (IndentedLineBuffer out2 = new IndentedLineBuffer();){
            ShapeOutputVisitor visitorMem = new ShapeOutputVisitor(prefixMappingWithStd, nodeFmt, (IndentedWriter)out2);
            if (sh.getShapeNode().isURI()) {
                CompactWriter.output((IndentedWriter)out2, nodeFmt, visitorMem, sh);
            }
            out.print(out2.asString());
        }
        catch (ShaclNotCompactException ex) {
            out.print("## Can't write in compact syntax: ");
            nodeFmt.format((AWriter)out, sh.getShapeNode());
            out.println();
        }
    }

    private static NodeFormatter formatterPrefixMap(PrefixMapping prefixMapping) {
        PrefixMap pmap = CompactWriter.prefixMapWithStd(prefixMapping);
        NodeFormatterTTL nodeFmt = new NodeFormatterTTL(null, pmap);
        return nodeFmt;
    }

    private static PrefixMap prefixMapWithStd(PrefixMapping prefixMapping) {
        PrefixMap pmap = SHACLC.withStandardPrefixes();
        prefixMapping.getNsPrefixMap().forEach((p, u) -> pmap.add(p, u));
        return pmap;
    }

    public static void output(IndentedWriter out, NodeFormatter nodeFmt, ShapeOutputVisitor visitor, Shape sh) {
        List targetImplicitClasses = sh.getTargets().stream().filter(t -> t.getTargetType() == TargetType.implicitClass).collect(Collectors.toList());
        List<Target> targetClasses = sh.getTargets().stream().filter(t -> t.getTargetType() == TargetType.targetClass).collect(Collectors.toList());
        if (targetImplicitClasses.isEmpty()) {
            out.print("shape ");
            nodeFmt.format((AWriter)out, sh.getShapeNode());
            if (!targetClasses.isEmpty()) {
                out.print(" ->");
                targetClasses.forEach(t -> {
                    out.print(" ");
                    nodeFmt.format((AWriter)out, t.getObject());
                });
            }
        } else {
            if (targetImplicitClasses.size() > 1) {
                CompactWriter.notShaclc("Multiple implicit classes");
            }
            if (!targetClasses.isEmpty()) {
                CompactWriter.notShaclc("Implicit classes and targetClass");
            }
            Target target = (Target)targetImplicitClasses.get(0);
            out.print("shapeClass ");
            nodeFmt.format((AWriter)out, target.getObject());
        }
        out.println(" {");
        out.incIndent();
        sh.visit(visitor);
        out.decIndent();
        out.ensureStartOfLine();
        out.println("}");
    }

    public static void output(IndentedWriter out, NodeFormatter nodeFmt, Shape sh) {
        PrefixMapping prefixMappingWithStd = SHACLC.withStandardPrefixes(sh.getShapeGraph().getPrefixMapping());
        ShapeOutputVisitor visitor = new ShapeOutputVisitor(prefixMappingWithStd, nodeFmt, out);
        sh.visit(visitor);
    }

    public static Constraint getCompactPrintable(Shape other) {
        if (other.isPropertyShape()) {
            return null;
        }
        if (!other.getPropertyShapes().isEmpty()) {
            return null;
        }
        Collection<Constraint> constraints = other.getConstraints();
        if (constraints.size() != 1) {
            return null;
        }
        return (Constraint)CollectionUtils.oneElt(constraints);
    }

    private static void notShaclc(String string) {
        throw new ShaclException("Not supported in SHACLC: " + string);
    }

    private static /* synthetic */ void lambda$print$2(IndentedWriter out, PrefixMapping prefixMappingWithStd, NodeFormatter nodeFmt, ShapeOutputVisitor visitor, Shape sh) {
        out.println();
        CompactWriter.writeOneShapeCompact(out, prefixMappingWithStd, nodeFmt, visitor, sh);
    }

    private static /* synthetic */ void lambda$print$1(IndentedWriter out, NodeFormatter nodeFmt, Node n) {
        out.print("IMPORTS ");
        out.pad(15);
        nodeFmt.format((AWriter)out, n);
        out.println();
    }
}

