/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.sse.builders;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.query.ResultSet;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ResultSetStream;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.sse.Item;
import org.apache.jena.sparql.sse.ItemList;
import org.apache.jena.sparql.sse.builders.BuilderBinding;
import org.apache.jena.sparql.sse.builders.BuilderLib;
import org.apache.jena.sparql.sse.builders.BuilderNode;
import org.apache.jena.sparql.sse.builders.BuilderTable;

public class BuilderResultSet {
    public static ResultSet build(Item item) {
        if (item.isTagged("table")) {
            return BuilderTable.build(item).toResultSet();
        }
        BuilderLib.checkTagged(item, "resultset", "Not a (resultset ...)");
        ItemList list = item.getList();
        List<Var> vars = BuilderNode.buildVarList(list.get(1));
        int start = 2;
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        for (int i = start; i < list.size(); ++i) {
            Item itemRow = list.get(i);
            Binding b = BuilderBinding.build(itemRow);
            bindings.add(b);
        }
        QueryIterPlainWrapper qIter = new QueryIterPlainWrapper(bindings.listIterator());
        return new ResultSetStream(Var.varNames(vars), null, qIter);
    }
}

