/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.modify;

import org.apache.jena.graph.Node;
import org.apache.jena.sparql.modify.UpdateSink;
import org.apache.jena.sparql.modify.UsingList;
import org.apache.jena.sparql.modify.request.QuadDataAccSink;
import org.apache.jena.sparql.modify.request.UpdateWithUsing;
import org.apache.jena.update.Update;
import org.apache.jena.update.UpdateException;

public class UsingUpdateSink
implements UpdateSink {
    private final UpdateSink sink;
    private final UsingList usingList;

    public UsingUpdateSink(UpdateSink sink, UsingList usingList) {
        this.sink = sink;
        this.usingList = usingList;
    }

    public void send(Update update) {
        if (null != this.usingList && this.usingList.usingIsPresent() && update instanceof UpdateWithUsing) {
            UpdateWithUsing upu = (UpdateWithUsing)update;
            if (upu.getUsing().size() != 0 || upu.getUsingNamed().size() != 0 || upu.getWithIRI() != null) {
                throw new UpdateException("SPARQL Update: Protocol using-graph-uri or using-named-graph-uri present where update request has USING, USING NAMED or WITH");
            }
            for (Node node : this.usingList.getUsing()) {
                upu.addUsing(node);
            }
            for (Node node : this.usingList.getUsingNamed()) {
                upu.addUsingNamed(node);
            }
        }
        this.sink.send(update);
    }

    @Override
    public QuadDataAccSink createInsertDataSink() {
        return this.sink.createInsertDataSink();
    }

    @Override
    public QuadDataAccSink createDeleteDataSink() {
        return this.sink.createDeleteDataSink();
    }

    public void flush() {
        this.sink.flush();
    }

    public void close() {
        this.sink.close();
    }
}

