/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.iterator;

import java.util.Iterator;
import java.util.Objects;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.engine.iterator.QueryIterTriplePattern;
import org.apache.jena.util.iterator.ExtendedIterator;

public class RX {
    public static final boolean DATAPATH = true;

    public static QueryIterator rdfStarTriple(QueryIterator chain, Triple pattern, ExecutionContext execCxt) {
        if (!RX.tripleHasNodeTriple(pattern)) {
            return RX.matchData(chain, pattern, execCxt);
        }
        return RX.rdfStarTripleSub(chain, pattern, execCxt);
    }

    private static QueryIterator matchData(QueryIterator chain, Triple pattern, ExecutionContext execCxt) {
        return new QueryIterTriplePattern(chain, pattern, execCxt);
    }

    private static boolean tripleHasNodeTriple(Triple triple) {
        return triple.getSubject().isNodeTriple() || triple.getObject().isNodeTriple();
    }

    private static QueryIterator rdfStarTripleSub(QueryIterator input, Triple pattern, ExecutionContext execCxt) {
        Iterator matches = Iter.flatMap((Iterator)input, binding -> RX.rdfStarTripleSub(binding, pattern, execCxt));
        return new QueryIterPlainWrapper(matches, execCxt);
    }

    private static Iterator<Binding> rdfStarTripleSub(Binding input, Triple tPattern, ExecutionContext execCxt) {
        Node s = RX.nodeTopLevel(tPattern.getSubject());
        Node p = RX.nodeTopLevel(tPattern.getPredicate());
        Node o = RX.nodeTopLevel(tPattern.getObject());
        Graph graph = execCxt.getActiveGraph();
        ExtendedIterator graphIter = graph.find(s, p, o);
        ExtendedIterator matched = graphIter.mapWith(tData -> RX.matchTriple(input, tData, tPattern)).filterDrop(Objects::isNull);
        return matched;
    }

    public static Node nodeTopLevel(Node node) {
        if (Var.isVar(node)) {
            return Node.ANY;
        }
        if (node.isNodeTriple() && !node.getTriple().isConcrete()) {
            return Node.ANY;
        }
        return node;
    }

    public static Binding matchTriple(Binding input, Triple tData, Triple tPattern) {
        BindingBuilder bb = Binding.builder(input);
        boolean r = RX.matchTriple(bb, tData, tPattern);
        return r ? bb.build() : null;
    }

    private static boolean matchTriple(BindingBuilder bb, Triple tData, Triple tPattern) {
        Node sPattern = tPattern.getSubject();
        Node pPattern = tPattern.getPredicate();
        Node oPattern = tPattern.getObject();
        Node sData = tData.getSubject();
        Node pData = tData.getPredicate();
        Node oData = tData.getObject();
        if (!RX.match(bb, sData, sPattern)) {
            return false;
        }
        if (!RX.match(bb, pData, pPattern)) {
            return false;
        }
        return RX.match(bb, oData, oPattern);
    }

    public static Binding matchQuad(Binding input, Quad qData, Node tGraphNode, Triple tPattern) {
        BindingBuilder bb = Binding.builder(input);
        boolean r = RX.matchQuad(bb, qData, tGraphNode, tPattern);
        return r ? bb.build() : null;
    }

    private static boolean matchQuad(BindingBuilder bb, Quad qData, Node tGraphNode, Triple tPattern) {
        Node sPattern = tPattern.getSubject();
        Node pPattern = tPattern.getPredicate();
        Node oPattern = tPattern.getObject();
        Node gData = qData.getGraph();
        Node sData = qData.getSubject();
        Node pData = qData.getPredicate();
        Node oData = qData.getObject();
        if (!RX.match(bb, gData, tGraphNode)) {
            return false;
        }
        if (!RX.match(bb, sData, sPattern)) {
            return false;
        }
        if (!RX.match(bb, pData, pPattern)) {
            return false;
        }
        return RX.match(bb, oData, oPattern);
    }

    private static boolean match(BindingBuilder bb, Node nData, Node nPattern) {
        if (nPattern == null) {
            return true;
        }
        if (nData == Node.ANY) {
            return true;
        }
        if ((nPattern = Var.lookup(v -> bb.get((Var)((Object)v)), nPattern)).isConcrete()) {
            return nPattern.equals((Object)nData);
        }
        if (Var.isVar(nPattern)) {
            Var var = Var.alloc(nPattern);
            bb.add(var, nData);
            return true;
        }
        if (!nData.isNodeTriple()) {
            return false;
        }
        Triple tPattern = nPattern.getTriple();
        Triple tData = nData.getTriple();
        return RX.matchTriple(bb, tData, tPattern);
    }
}

