/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.resultset;

import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.jena.query.ResultSet;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.riot.resultset.ResultSetReader;
import org.apache.jena.riot.resultset.ResultSetReaderFactory;
import org.apache.jena.riot.resultset.rw.ResultSetReaderCSV;
import org.apache.jena.riot.resultset.rw.ResultSetReaderJSON;
import org.apache.jena.riot.resultset.rw.ResultSetReaderTSV;
import org.apache.jena.riot.resultset.rw.ResultSetReaderThrift;
import org.apache.jena.riot.resultset.rw.ResultSetReaderXML;
import org.apache.jena.sparql.resultset.SPARQLResult;
import org.apache.jena.sparql.util.Context;

public class ResultSetReaderRegistry {
    private static Map<Lang, ResultSetReaderFactory> registry = new HashMap<Lang, ResultSetReaderFactory>();
    private static boolean initialized = false;
    private static ResultSetReader readerNo = new ResultSetReader(){

        @Override
        public ResultSet read(InputStream in, Context context2) {
            return null;
        }

        @Override
        public ResultSet read(Reader in, Context context2) {
            return null;
        }

        @Override
        public SPARQLResult readAny(InputStream in, Context context2) {
            return null;
        }
    };

    public static ResultSetReaderFactory getFactory(Lang lang) {
        Objects.requireNonNull(lang);
        return registry.get(lang);
    }

    public static void register(Lang lang, ResultSetReaderFactory factory) {
        Objects.requireNonNull(lang);
        Objects.requireNonNull(factory);
        registry.put(lang, factory);
    }

    public static boolean isRegistered(Lang lang) {
        Objects.requireNonNull(lang);
        return registry.containsKey(lang);
    }

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        ResultSetReaderRegistry.register(ResultSetLang.RS_XML, ResultSetReaderXML.factory);
        ResultSetReaderRegistry.register(ResultSetLang.RS_JSON, ResultSetReaderJSON.factory);
        ResultSetReaderRegistry.register(ResultSetLang.RS_Thrift, ResultSetReaderThrift.factory);
        ResultSetReaderRegistry.register(ResultSetLang.RS_CSV, ResultSetReaderCSV.factory);
        ResultSetReaderRegistry.register(ResultSetLang.RS_TSV, ResultSetReaderTSV.factory);
    }
}

