/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.irix;

import java.util.Objects;
import org.apache.jena.atlas.lib.IRILib;
import org.apache.jena.irix.IRIException;
import org.apache.jena.irix.IRIx;
import org.apache.jena.irix.IRIxResolver;
import org.apache.jena.irix.SystemIRIx;

public class IRIs {
    public static IRIx reference(String iriStr) {
        Objects.requireNonNull(iriStr);
        IRIx iri = IRIx.create(iriStr);
        if (!iri.isReference()) {
            throw new IRIException("Not an RDF IRI: " + iriStr);
        }
        return iri;
    }

    public static boolean check(String iriStr) {
        Objects.requireNonNull(iriStr);
        try {
            IRIs.checkEx(iriStr);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static String checkEx(String iriStr) {
        Objects.requireNonNull(iriStr);
        return IRIs.reference(iriStr).str();
    }

    public static IRIx getSystemBase() {
        return SystemIRIx.getSystemBase();
    }

    public static String getBaseStr() {
        return SystemIRIx.getSystemBase().toString();
    }

    public static String toBase(String baseURI) {
        String scheme = IRIs.scheme(baseURI);
        if (scheme != null && scheme.length() == 1) {
            scheme = "file";
        }
        if (scheme != null && scheme.equals("file")) {
            return IRILib.filenameToIRI((String)baseURI);
        }
        return IRIs.getSystemBase().resolve(baseURI).toString();
    }

    public static IRIxResolver stdResolver() {
        return IRIs.resolver(IRIs.getSystemBase());
    }

    public static IRIxResolver resolver(String base) {
        return IRIxResolver.create(base).resolve(true).allowRelative(false).build();
    }

    public static IRIxResolver resolver(IRIx base) {
        return IRIxResolver.create(base).resolve(true).allowRelative(false).build();
    }

    public static IRIxResolver absoluteResolver() {
        return IRIxResolver.create().noBase().resolve(false).allowRelative(false).build();
    }

    public static IRIxResolver relativeResolver() {
        return IRIxResolver.create().noBase().resolve(false).allowRelative(true).build();
    }

    public static String resolve(String iriStr) {
        if (iriStr == null) {
            return IRIs.getSystemBase().str();
        }
        return IRIs.resolve(IRIs.getSystemBase(), iriStr);
    }

    public static IRIx resolveIRI(String iriStr) {
        if (iriStr == null) {
            return IRIs.getSystemBase();
        }
        return IRIs.getSystemBase().resolve(iriStr);
    }

    public static String resolve(IRIx base, String iriStr) {
        return base.resolve(iriStr).str();
    }

    public static String resolve(IRIx base, IRIx iri) {
        return base.resolve(iri).str();
    }

    public static String resolve(String baseStr, String iriStr) {
        IRIx base = IRIx.create(baseStr);
        if (!base.isReference()) {
            throw new IRIException("Not suitable as a base URI: '" + baseStr + "'");
        }
        return IRIs.resolve(base, iriStr);
    }

    public static String scheme(String str) {
        int idx = IRIs.scheme(str, 0);
        if (idx <= 0 || idx > str.length()) {
            return null;
        }
        return str.substring(0, idx);
    }

    private static int scheme(String str, int start) {
        int end = str.length();
        for (int p = start; p < end; ++p) {
            char c = str.charAt(p);
            if (c == ':') {
                return p;
            }
            if (IRIs.isAlpha(c)) continue;
            if (p == start) {
                return -1;
            }
            if (IRIs.isDigit(c) || c == '+' || c == '-' || c == '.') continue;
            return -1;
        }
        return 0;
    }

    private static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private static boolean isAlpha(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z';
    }
}

