/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.enhanced;

import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.atlas.lib.CacheFactory;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.enhanced.Personality;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.RDFNode;

public class EnhGraph {
    protected Graph graph;
    protected Cache<Node, RDFNode> enhNodes = CacheFactory.createCache((int)1000);
    private Personality<RDFNode> personality;

    public EnhGraph(Graph g, Personality<RDFNode> p) {
        this.graph = g;
        this.personality = p;
    }

    public Graph asGraph() {
        return this.graph;
    }

    public final int hashCode() {
        return this.graph.hashCode();
    }

    public final boolean equals(Object o) {
        return this == o || o instanceof EnhGraph && this.graph.equals(((EnhGraph)o).asGraph());
    }

    public final boolean isIsomorphicWith(EnhGraph eg) {
        return this.graph.isIsomorphicWith(eg.graph);
    }

    public <X extends RDFNode> X getNodeAs(Node n, Class<X> interf) {
        EnhNode eh = (EnhNode)this.enhNodes.getIfPresent((Object)n);
        if (eh == null) {
            RDFNode constructed = (RDFNode)this.personality.newInstance(interf, n, this);
            this.enhNodes.put((Object)n, (Object)constructed);
            return (X)constructed;
        }
        return eh.viewAs(interf);
    }

    public void setNodeCache(Cache<Node, RDFNode> cc) {
        this.enhNodes = cc;
    }

    protected Personality<RDFNode> getPersonality() {
        return this.personality;
    }
}

