/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.jena.atlas.lib.Lib;

public abstract class IteratorSlotted<T>
implements Iterator<T> {
    private boolean finished = false;
    private boolean slotIsSet = false;
    private T slot = null;

    protected IteratorSlotted() {
    }

    protected abstract T moveToNext();

    protected abstract boolean hasMore();

    protected void closeIterator() {
    }

    protected boolean isFinished() {
        return this.finished;
    }

    @Override
    public final boolean hasNext() {
        if (this.finished) {
            return false;
        }
        if (this.slotIsSet) {
            return true;
        }
        boolean r = this.hasMore();
        if (!r) {
            this.close();
            return false;
        }
        this.slot = this.moveToNext();
        if (this.slot == null) {
            this.close();
            return false;
        }
        this.slotIsSet = true;
        return true;
    }

    @Override
    public final T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException(Lib.className(this));
        }
        T obj = this.slot;
        this.slot = null;
        this.slotIsSet = false;
        return obj;
    }

    public final T peek() {
        return this.peek(null);
    }

    public final T peek(T dft) {
        this.hasNext();
        if (!this.slotIsSet) {
            return dft;
        }
        return this.slot;
    }

    public final void close() {
        if (this.finished) {
            return;
        }
        this.closeIterator();
        this.slotIsSet = false;
        this.slot = null;
        this.finished = true;
    }
}

