/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.cmd;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.jena.cmd.ArgProc;

public class CommandLineBase {
    private List<String> argList = new ArrayList<String>();
    boolean splitTerms = true;

    public CommandLineBase(String[] args) {
        this.setArgs(args);
    }

    public CommandLineBase() {
    }

    public void setArgs(String[] argv) {
        this.argList = this.processArgv(argv);
    }

    protected List<String> getArgList() {
        return this.argList;
    }

    protected String getArg(int i) {
        if (i < 0 || i >= this.argList.size()) {
            return null;
        }
        return this.argList.get(i);
    }

    protected void apply(ArgProc a) {
        a.startArgs();
        IntStream.range(0, this.argList.size()).forEach(i -> a.arg(this.argList.get(i), i));
        a.finishArgs();
    }

    private List<String> processArgv(String[] argv) {
        ArrayList<String> argList = new ArrayList<String>();
        boolean positional = false;
        for (String anArgv : argv) {
            Object argStr = anArgv;
            if (positional || !((String)argStr).startsWith("-")) {
                argList.add((String)argStr);
                continue;
            }
            if (((String)argStr).equals("-") || ((String)argStr).equals("--")) {
                positional = true;
                argList.add("--");
                continue;
            }
            if (!((String)argStr).startsWith("--")) {
                argStr = "-" + (String)argStr;
            }
            if (!this.splitTerms) {
                argList.add((String)argStr);
                continue;
            }
            int j1 = ((String)argStr).indexOf(61);
            int j2 = ((String)argStr).indexOf(58);
            int j = -1;
            if (j1 > 0 && j2 > 0) {
                j = Math.min(j1, j2);
            } else {
                if (j1 > 0) {
                    j = j1;
                }
                if (j2 > 0) {
                    j = j2;
                }
            }
            if (j < 0) {
                argList.add((String)argStr);
                continue;
            }
            String argStr1 = ((String)argStr).substring(0, j);
            String argStr2 = ((String)argStr).substring(j + 1);
            argList.add(argStr1);
            argList.add(argStr2);
        }
        return argList;
    }
}

