/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdline;

import org.apache.jena.cmd.ArgDecl;
import org.apache.jena.cmd.CmdArgModule;
import org.apache.jena.cmd.CmdException;
import org.apache.jena.cmd.CmdGeneral;
import org.apache.jena.cmd.ModBase;
import org.apache.jena.irix.IRIException;
import org.apache.jena.irix.IRIs;
import org.apache.jena.irix.IRIx;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RiotException;

public class ModLangParse
extends ModBase {
    private ArgDecl argCheck = new ArgDecl(false, "check");
    private ArgDecl argNoCheck = new ArgDecl(false, "nocheck", "noCheck");
    private ArgDecl argSink = new ArgDecl(false, "sink", "null");
    private ArgDecl argCount = new ArgDecl(false, "count");
    private ArgDecl argStrict = new ArgDecl(false, "strict");
    private ArgDecl argValidate = new ArgDecl(false, "validate");
    private ArgDecl argStop = new ArgDecl(false, "stopOnError", "stoponerror", "stop");
    private ArgDecl argStopWarn = new ArgDecl(false, "stopOnWarning", "stoponwarning", "stop-warnings");
    private ArgDecl argBase = new ArgDecl(true, "base");
    private ArgDecl argRDFS = new ArgDecl(true, "rdfs");
    private ArgDecl argSyntax = new ArgDecl(true, "syntax");
    private String rdfsVocabFilename = null;
    private Model rdfsVocab = null;
    private String baseIRI = null;
    private boolean explicitCheck = false;
    private boolean explicitNoCheck = false;
    private boolean stopOnBadTerm = false;
    private boolean stopOnWarnings = false;
    private boolean bitbucket = false;
    private boolean strict = false;
    private boolean validate = false;
    private boolean outputCount = false;
    private Lang lang = null;

    @Override
    public void registerWith(CmdGeneral cmdLine) {
        cmdLine.getUsage().startCategory("Parser control");
        cmdLine.add(this.argSink, "--sink", "Parse but throw away output");
        cmdLine.add(this.argSyntax, "--syntax=NAME", "Set syntax (otherwise syntax guessed from file extension)");
        cmdLine.add(this.argBase, "--base=URI", "Set the base URI (does not apply to N-triples and N-Quads)");
        cmdLine.add(this.argCheck, "--check", "Additional checking of RDF terms");
        cmdLine.add(this.argStrict, "--strict", "Run with in strict mode");
        cmdLine.add(this.argValidate, "--validate", "Same as --sink --check --strict");
        cmdLine.add(this.argCount, "--count", "Count triples/quads parsed, not output them");
        cmdLine.add(this.argRDFS, "--rdfs=file", "Apply some RDFS inference using the vocabulary in the file");
        cmdLine.add(this.argNoCheck, "--nocheck", "Turn off checking of RDF terms");
    }

    @Override
    public void processArgs(CmdArgModule cmdLine) {
        if (cmdLine.contains(this.argValidate)) {
            this.validate = true;
            this.strict = true;
            this.explicitCheck = true;
            this.bitbucket = true;
        }
        if (cmdLine.contains(this.argSyntax)) {
            String syntax = cmdLine.getValue(this.argSyntax);
            Lang lang$ = RDFLanguages.nameToLang((String)syntax);
            if (lang$ == null) {
                throw new CmdException("Can not detemine the syntax from '" + syntax + "'");
            }
            this.lang = lang$;
        }
        if (cmdLine.contains(this.argCheck)) {
            this.explicitCheck = true;
        }
        if (cmdLine.contains(this.argNoCheck)) {
            this.explicitNoCheck = true;
        }
        if (cmdLine.contains(this.argStrict)) {
            this.strict = true;
        }
        if (cmdLine.contains(this.argBase)) {
            this.baseIRI = cmdLine.getValue(this.argBase);
            try {
                IRIx iri2 = IRIs.reference((String)this.baseIRI);
                if (!iri2.isAbsolute()) {
                    throw new CmdException("Base IRI not suitable for use as a base for RDF: " + this.baseIRI);
                }
            }
            catch (IRIException ex) {
                throw new CmdException("Bad base IRI: " + this.baseIRI);
            }
        }
        if (cmdLine.contains(this.argStop)) {
            this.stopOnBadTerm = true;
        }
        if (cmdLine.contains(this.argStopWarn)) {
            this.stopOnWarnings = true;
        }
        if (cmdLine.contains(this.argSink)) {
            this.bitbucket = true;
        }
        if (cmdLine.contains(this.argCount)) {
            this.bitbucket = true;
            this.outputCount = true;
        }
        if (cmdLine.contains(this.argRDFS)) {
            try {
                this.rdfsVocabFilename = cmdLine.getArg(this.argRDFS).getValue();
                this.rdfsVocab = RDFDataMgr.loadModel((String)this.rdfsVocabFilename);
            }
            catch (RiotException ex) {
                throw new CmdException("Error in RDFS vocabulary: " + this.rdfsVocabFilename);
            }
            catch (Exception ex) {
                throw new CmdException("Error: " + ex.getMessage());
            }
        }
    }

    public boolean explicitChecking() {
        return this.explicitCheck;
    }

    public boolean explicitNoChecking() {
        return this.explicitNoCheck;
    }

    public boolean strictMode() {
        return this.strict;
    }

    public boolean validate() {
        return this.validate;
    }

    public boolean outputCount() {
        return this.outputCount;
    }

    public boolean stopOnBadTerm() {
        return this.stopOnBadTerm;
    }

    public boolean stopOnWarnings() {
        return this.stopOnWarnings;
    }

    public boolean toBitBucket() {
        return this.bitbucket;
    }

    public String getBaseIRI() {
        return this.baseIRI;
    }

    public Model getRDFSVocab() {
        return this.rdfsVocab;
    }

    public Lang getLang() {
        return this.lang;
    }
}

